/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v2.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import java.io.Serializable;
import java.util.List;
import org.openstack4j.api.types.ServiceType;
import org.openstack4j.model.common.Link;
import org.openstack4j.model.identity.AuthStore;
import org.openstack4j.model.identity.AuthVersion;
import org.openstack4j.model.identity.v2.Access;
import org.openstack4j.model.identity.v2.Endpoint;
import org.openstack4j.model.identity.v2.Role;
import org.openstack4j.model.identity.v2.TokenV2;
import org.openstack4j.openstack.common.GenericLink;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.identity.functions.ServiceFunctions;
import org.openstack4j.openstack.identity.v2.domain.KeystoneEndpoint;
import org.openstack4j.openstack.identity.v2.domain.KeystoneRole;
import org.openstack4j.openstack.identity.v2.domain.KeystoneToken;
import org.openstack4j.openstack.identity.v2.domain.TokenAuth;

@JsonRootName(value="access")
public class KeystoneAccess
implements Access {
    private static final long serialVersionUID = 1L;
    private static final String CACHE_FMT = "%s:%s";
    private KeystoneToken token;
    private List<AccessService> serviceCatalog;
    private AccessUser user;
    private String endpoint;
    private AuthStore credentials;
    private TokenAuth tokenAuth;
    @JsonIgnore
    private volatile SortedSetMultimap<String, AccessService> aggregatedCatalog;

    @Override
    public TokenV2 getToken() {
        return this.token;
    }

    @Override
    public List<? extends Access.Service> getServiceCatalog() {
        return this.serviceCatalog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonIgnore
    public SortedSetMultimap<String, AccessService> getAggregatedCatalog() {
        if (this.aggregatedCatalog == null) {
            KeystoneAccess keystoneAccess = this;
            synchronized (keystoneAccess) {
                if (this.aggregatedCatalog == null) {
                    this.aggregatedCatalog = TreeMultimap.create();
                    for (AccessService sc : this.serviceCatalog) {
                        String nameKey = ServiceFunctions.TYPE_WITHOUT_VERSION.apply(sc.getName());
                        String typeKey = ServiceFunctions.TYPE_WITHOUT_VERSION.apply(sc.getType());
                        this.aggregatedCatalog.put(nameKey, sc);
                        this.aggregatedCatalog.put(typeKey, sc);
                    }
                }
            }
        }
        return this.aggregatedCatalog;
    }

    @Override
    public Access.UserDetails getUser() {
        return this.user;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public AuthStore getCredentials() {
        return this.credentials;
    }

    public TokenAuth getTokenAuth() {
        return this.tokenAuth;
    }

    public boolean isCredentialType() {
        return this.credentials != null;
    }

    public KeystoneAccess applyContext(String endpoint, AuthStore credentials) {
        this.credentials = credentials;
        this.endpoint = endpoint;
        return this;
    }

    public KeystoneAccess applyContext(String endpoint, TokenAuth token) {
        this.endpoint = endpoint;
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("token", this.token).add("serviceCatalog", this.serviceCatalog).add("user", this.user).toString();
    }

    @Override
    @JsonIgnore
    public AuthVersion getVersion() {
        return AuthVersion.V2;
    }

    @Override
    @JsonIgnore
    public <T> T unwrap() {
        return (T)this;
    }

    @Override
    @JsonIgnore
    public String getCacheIdentifier() {
        String uniq = null;
        uniq = this.token.getTenant() != null ? this.token.getTenant().getId() : (this.user != null ? this.user.getId() : "");
        return String.format(CACHE_FMT, this.endpoint, uniq);
    }

    public static final class AccessService
    implements Access.Service,
    Comparable<AccessService>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String type;
        private String name;
        private List<KeystoneEndpoint> endpoints;
        private ServiceType serviceType;
        @JsonIgnore
        private Integer version;
        @JsonProperty(value="endpoints_links")
        private List<GenericLink> endpointsLinks;

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        @JsonIgnore
        public ServiceType getServiceType() {
            if (this.serviceType == null) {
                this.serviceType = ServiceType.forName(this.name);
            }
            if (this.serviceType == ServiceType.UNKNOWN) {
                this.serviceType = ServiceType.forName(this.type);
            }
            return this.serviceType;
        }

        @Override
        public List<? extends Endpoint> getEndpoints() {
            return this.endpoints;
        }

        @Override
        public List<? extends Link> getEndpointsLinks() {
            return this.endpointsLinks;
        }

        @Override
        @JsonIgnore
        public Integer getVersion() {
            if (this.version == null) {
                this.version = ServiceFunctions.VERSION_FROM_TYPE.apply(this.type);
            }
            return this.version;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).omitNullValues().add("name", this.name).add("type", this.type).add("version", this.getVersion()).add("endpoints", this.endpoints).addValue("\n").toString();
        }

        @Override
        public int compareTo(AccessService o) {
            return this.getVersion().compareTo(o.getVersion());
        }
    }

    public static class AccessUsers
    extends ListResult<AccessUser> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="users")
        private List<AccessUser> list;

        @Override
        public List<AccessUser> value() {
            return this.list;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class AccessUser
    implements Access.UserDetails,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String id;
        private String name;
        private String username;
        private List<AccessRole> roles;
        private Boolean enabled;
        @JsonProperty(value="roles_links")
        private List<GenericLink> rolesLinks;

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getUsername() {
            return this.username;
        }

        @Override
        public List<? extends Role> getRoles() {
            return this.roles;
        }

        @Override
        public List<? extends Link> getRolesLinks() {
            return this.rolesLinks;
        }

        @Override
        public boolean isEnabled() {
            return this.enabled != null && this.enabled != false;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).omitNullValues().add("id", this.id).add("name", this.name).add("username", this.username).add("enabled", this.enabled).add("roles", this.roles).add("rolesLinks", this.rolesLinks).toString();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class AccessRole
        extends KeystoneRole {
            private static final long serialVersionUID = 1L;

            @Override
            public String toString() {
                return MoreObjects.toStringHelper(this).omitNullValues().add("id", this.getId()).add("name", this.getName()).add("tenantId", this.getTenantId()).toString();
            }
        }
    }
}

