/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v3.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.List;
import java.util.Map;
import org.openstack4j.model.identity.v3.Domain;
import org.openstack4j.model.identity.v3.User;
import org.openstack4j.model.identity.v3.builder.UserBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.identity.v3.domain.KeystoneDomain;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonRootName(value="user")
public class KeystoneUser
implements User {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private String id;
    @JsonProperty
    private String name;
    @JsonProperty
    private KeystoneDomain domain;
    @JsonProperty(value="domain_id")
    private String domainId;
    private String email;
    private String password;
    private String description;
    @JsonProperty(value="default_project_id")
    private String defaultProjectId;
    private Map<String, String> links;
    private Boolean enabled = true;

    public static UserBuilder builder() {
        return new UserConcreteBuilder();
    }

    @Override
    public UserBuilder toBuilder() {
        return new UserConcreteBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDomainId() {
        return this.domainId;
    }

    @Override
    public Domain getDomain() {
        return this.domain;
    }

    @Override
    public String getDefaultProjectId() {
        return this.defaultProjectId;
    }

    @Override
    public Map<String, String> getLinks() {
        return this.links;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled != null && this.enabled != false;
    }

    @Override
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("name", this.name).add("id", this.id).add("email", this.email).add("password", this.password).add("description", this.description).add("domainId", this.domainId).add("links", this.links).add("enabled", this.enabled).add("defaultProjectId", this.defaultProjectId).toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KeystoneUser that = (KeystoneUser)KeystoneUser.class.cast(obj);
        return Objects.equal(this.name, that.name) && Objects.equal(this.id, that.id) && Objects.equal(this.email, that.email) && Objects.equal(this.password, that.password) && Objects.equal(this.description, that.description) && Objects.equal(this.domainId, that.domainId) && Objects.equal(this.links, that.domainId) && Objects.equal(this.enabled, that.enabled) && Objects.equal(this.defaultProjectId, that.defaultProjectId);
    }

    public static class UserConcreteBuilder
    implements UserBuilder {
        KeystoneUser model;

        UserConcreteBuilder() {
            this(new KeystoneUser());
        }

        UserConcreteBuilder(KeystoneUser model) {
            this.model = model;
        }

        @Override
        public UserBuilder id(String id) {
            this.model.id = id;
            return this;
        }

        @Override
        public User build() {
            return this.model;
        }

        @Override
        public UserBuilder from(User in) {
            if (in != null) {
                this.model = (KeystoneUser)in;
            }
            return this;
        }

        @Override
        public UserBuilder name(String name) {
            this.model.name = name;
            return this;
        }

        @Override
        public UserBuilder defaultProjectId(String defaultProjectId) {
            this.model.defaultProjectId = defaultProjectId;
            return this;
        }

        @Override
        public UserBuilder domainId(String domainId) {
            this.model.domainId = domainId;
            return this;
        }

        @Override
        public UserBuilder domain(Domain domain) {
            if (domain != null && domain.getId() != null) {
                this.model.domainId = domain.getId();
            }
            return this;
        }

        @Override
        public UserBuilder email(String email) {
            this.model.email = email;
            return this;
        }

        @Override
        public UserBuilder password(String password) {
            this.model.password = password;
            return this;
        }

        @Override
        public UserBuilder links(Map<String, String> links) {
            this.model.links = links;
            return this;
        }

        @Override
        public UserBuilder enabled(boolean enabled) {
            this.model.enabled = enabled;
            return this;
        }

        @Override
        public UserBuilder description(String description) {
            this.model.description = description;
            return this;
        }
    }

    public static class Users
    extends ListResult<KeystoneUser> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="users")
        private List<KeystoneUser> list;

        @Override
        public List<KeystoneUser> value() {
            return this.list;
        }
    }
}

