/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v3.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.identity.v3.GroupService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.identity.v3.Group;
import org.openstack4j.model.identity.v3.Role;
import org.openstack4j.model.identity.v3.User;
import org.openstack4j.openstack.identity.v3.domain.KeystoneGroup;
import org.openstack4j.openstack.identity.v3.domain.KeystoneRole;
import org.openstack4j.openstack.identity.v3.domain.KeystoneUser;
import org.openstack4j.openstack.identity.v3.internal.BaseIdentityServices;

public class GroupServiceImpl
extends BaseIdentityServices
implements GroupService {
    @Override
    public Group get(String groupId) {
        Preconditions.checkNotNull(groupId);
        return this.get(KeystoneGroup.class, "/groups", "/", groupId).execute();
    }

    @Override
    public List<? extends Group> getByName(String groupName) {
        return this.get(KeystoneGroup.Groups.class, this.uri("/groups", new Object[0])).param("name", groupName).execute().getList();
    }

    @Override
    public Group getByName(String groupName, String domainId) {
        Preconditions.checkNotNull(groupName);
        Preconditions.checkNotNull(domainId);
        return (Group)this.get(KeystoneGroup.Groups.class, this.uri("/groups", new Object[0])).param("name", groupName).param("domain_id", domainId).execute().first();
    }

    @Override
    public ActionResponse delete(String groupId) {
        Preconditions.checkNotNull(groupId);
        return this.deleteWithResponse("/groups", "/", groupId).execute();
    }

    @Override
    public Group update(Group group) {
        Preconditions.checkNotNull(group);
        return this.patch(KeystoneGroup.class, "/groups", "/", group.getId()).entity(group).execute();
    }

    @Override
    public Group create(Group group) {
        Preconditions.checkNotNull(group);
        return this.post(KeystoneGroup.class, this.uri("/groups", new Object[0])).entity(group).execute();
    }

    @Override
    public Group create(String domainId, String name, String description) {
        Preconditions.checkNotNull(domainId);
        Preconditions.checkNotNull(name);
        Preconditions.checkNotNull(description);
        return this.create((Group)KeystoneGroup.builder().domainId(domainId).name(name).description(description).build());
    }

    @Override
    public List<? extends Group> list() {
        return this.get(KeystoneGroup.Groups.class, this.uri("/groups", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends User> listGroupUsers(String groupId) {
        Preconditions.checkNotNull(groupId);
        return this.get(KeystoneUser.Users.class, this.uri("/groups/%s/users", groupId)).execute().getList();
    }

    @Override
    public ActionResponse checkGroupUser(String groupId, String userId) {
        Preconditions.checkNotNull(groupId);
        Preconditions.checkNotNull(userId);
        return this.head(ActionResponse.class, this.uri("/groups/%s/users/%s", groupId, userId)).execute();
    }

    @Override
    public ActionResponse addUserToGroup(String groupId, String userId) {
        Preconditions.checkNotNull(groupId);
        Preconditions.checkNotNull(userId);
        return this.put(ActionResponse.class, this.uri("groups/%s/users/%s", groupId, userId)).execute();
    }

    @Override
    public ActionResponse removeUserFromGroup(String groupId, String userId) {
        Preconditions.checkNotNull(groupId);
        Preconditions.checkNotNull(userId);
        return this.deleteWithResponse(this.uri("groups/%s/users/%s", groupId, userId)).execute();
    }

    @Override
    public List<? extends Role> listProjectGroupRoles(String groupId, String projectId) {
        Preconditions.checkNotNull(groupId);
        Preconditions.checkNotNull(projectId);
        return this.get(KeystoneRole.Roles.class, this.uri("projects/%s/groups/%s/roles", projectId, groupId)).execute().getList();
    }

    @Override
    public List<? extends Role> listDomainGroupRoles(String groupId, String domainId) {
        Preconditions.checkNotNull(groupId);
        Preconditions.checkNotNull(domainId);
        return this.get(KeystoneRole.Roles.class, this.uri("domains/%s/groups/%s/roles", domainId, groupId)).execute().getList();
    }
}

