/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.internal;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.openstack4j.api.client.CloudProvider;
import org.openstack4j.api.exceptions.OS4JException;
import org.openstack4j.api.types.ServiceType;
import org.openstack4j.core.transport.ExecutionOptions;
import org.openstack4j.core.transport.HttpMethod;
import org.openstack4j.core.transport.HttpRequest;
import org.openstack4j.core.transport.HttpResponse;
import org.openstack4j.core.transport.internal.HttpExecutor;
import org.openstack4j.model.ModelEntity;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.common.Payload;
import org.openstack4j.model.identity.AuthVersion;
import org.openstack4j.model.identity.v2.Access;
import org.openstack4j.model.identity.v3.Service;
import org.openstack4j.openstack.internal.OSClientSession;

public class BaseOpenStackService {
    private static ThreadLocal<String> reqIdContainer = new ThreadLocal();
    private ServiceType serviceType = ServiceType.IDENTITY;
    private Function<String, String> endpointFunc;

    protected BaseOpenStackService() {
    }

    protected BaseOpenStackService(ServiceType serviceType) {
        this(serviceType, null);
    }

    protected BaseOpenStackService(ServiceType serviceType, Function<String, String> endpointFunc) {
        this.serviceType = serviceType;
        this.endpointFunc = endpointFunc;
    }

    public String getXOpenstackRequestId() {
        return reqIdContainer.get();
    }

    protected <R> Invocation<R> get(Class<R> returnType, String ... path) {
        return this.builder(returnType, path, HttpMethod.GET);
    }

    protected Invocation<ActionResponse> getWithResponse(String ... path) {
        return this.builder(ActionResponse.class, path, HttpMethod.GET);
    }

    protected <R> Invocation<R> post(Class<R> returnType, String ... path) {
        return this.builder(returnType, path, HttpMethod.POST);
    }

    protected Invocation<ActionResponse> postWithResponse(String ... path) {
        return this.builder(ActionResponse.class, path, HttpMethod.POST);
    }

    protected <R> Invocation<R> put(Class<R> returnType, String ... path) {
        return this.builder(returnType, path, HttpMethod.PUT);
    }

    protected Invocation<ActionResponse> putWithResponse(String ... path) {
        return this.builder(ActionResponse.class, path, HttpMethod.PUT);
    }

    protected <R> Invocation<R> patch(Class<R> returnType, String ... path) {
        return this.builder(returnType, path, HttpMethod.PATCH);
    }

    protected Invocation<ActionResponse> patchWithResponse(String ... path) {
        return this.builder(ActionResponse.class, path, HttpMethod.PATCH);
    }

    protected <R> Invocation<R> delete(Class<R> returnType, String ... path) {
        return this.builder(returnType, path, HttpMethod.DELETE);
    }

    protected Invocation<ActionResponse> deleteWithResponse(String ... path) {
        return this.builder(ActionResponse.class, path, HttpMethod.DELETE);
    }

    protected <R> Invocation<R> head(Class<R> returnType, String ... path) {
        return this.builder(returnType, path, HttpMethod.HEAD);
    }

    protected <R> Invocation<R> request(HttpMethod method, Class<R> returnType, String path) {
        return this.builder(returnType, path, method);
    }

    protected String uri(String path, Object ... params) {
        if (params.length == 0) {
            return path;
        }
        return String.format(path, params);
    }

    private <R> Invocation<R> builder(Class<R> returnType, String[] path, HttpMethod method) {
        return this.builder(returnType, Joiner.on("").join(path), method);
    }

    private <R> Invocation<R> builder(Class<R> returnType, String path, HttpMethod method) {
        OSClientSession ses = OSClientSession.getCurrent();
        if (ses == null) {
            throw new OS4JException("Unable to retrieve current session. Please verify thread has a current session available.");
        }
        HttpRequest.RequestBuilder<R> req = HttpRequest.builder(returnType).endpointTokenProvider(ses).config(ses.getConfig()).method(method).path(path);
        Map<String, String> headers = ses.getHeaders();
        if (headers != null && headers.size() > 0) {
            return new Invocation<R>(req, this.serviceType, this.endpointFunc).headers(headers);
        }
        return new Invocation<R>(req, this.serviceType, this.endpointFunc);
    }

    protected int getServiceVersion() {
        OSClientSession session = OSClientSession.getCurrent();
        if (session.getAuthVersion() == AuthVersion.V3) {
            SortedSet<Service> services = ((OSClientSession.OSClientSessionV3)session).getToken().getAggregatedCatalog().get(this.serviceType.getType());
            Service service = ((OSClientSession.OSClientSessionV3)session).getToken().getAggregatedCatalog().get(this.serviceType.getType()).first();
            if (services.isEmpty()) {
                return 1;
            }
            return service.getVersion();
        }
        SortedSet<? extends Access.Service> services = ((OSClientSession.OSClientSessionV2)session).getAccess().getAggregatedCatalog().get(this.serviceType.getType());
        Access.Service service = ((OSClientSession.OSClientSessionV2)session).getAccess().getAggregatedCatalog().get(this.serviceType.getType()).first();
        if (services.isEmpty()) {
            return 1;
        }
        return service.getVersion();
    }

    protected <T> List<T> toList(T[] arr) {
        if (arr == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(arr);
    }

    protected CloudProvider getProvider() {
        return OSClientSession.getCurrent().getProvider();
    }

    protected static class Invocation<R> {
        HttpRequest.RequestBuilder<R> req;

        protected Invocation(HttpRequest.RequestBuilder<R> req, ServiceType serviceType, Function<String, String> endpointFunc) {
            this.req = req;
            req.serviceType(serviceType);
            req.endpointFunction(endpointFunc);
        }

        public HttpRequest<R> getRequest() {
            return this.req.build();
        }

        public Invocation<R> param(String name, Object value) {
            this.req.queryParam(name, value);
            return this;
        }

        public Invocation<R> updateParam(String name, Object value) {
            this.req.updateQueryParam(name, value);
            return this;
        }

        public Invocation<R> params(Map<String, ?> params) {
            if (params != null) {
                for (String name : params.keySet()) {
                    this.req.queryParam(name, params.get(name));
                }
            }
            return this;
        }

        public Invocation<R> param(boolean condition, String name, Object value) {
            if (condition) {
                this.req.queryParam(name, value);
            }
            return this;
        }

        public Invocation<R> paramLists(Map<String, ? extends Iterable<?>> params) {
            if (params != null) {
                for (Map.Entry<String, Iterable<?>> pair : params.entrySet()) {
                    for (Object value : pair.getValue()) {
                        this.req.queryParam(pair.getKey(), value);
                    }
                }
            }
            return this;
        }

        public Invocation<R> serviceType(ServiceType serviceType) {
            this.req.serviceType(serviceType);
            return this;
        }

        public Invocation<R> entity(ModelEntity entity) {
            this.req.entity(entity);
            return this;
        }

        public Invocation<R> entity(Payload<?> entity) {
            this.req.entity(entity);
            this.req.contentType("application/octet-stream");
            return this;
        }

        public Invocation<R> contentType(String contentType) {
            this.req.contentType(contentType);
            return this;
        }

        public Invocation<R> json(String json) {
            this.req.json(json);
            return this;
        }

        public Invocation<R> headers(Map<String, ?> headers) {
            if (headers != null) {
                this.req.headers(headers);
            }
            return this;
        }

        public Invocation<R> header(String name, Object value) {
            this.req.header(name, value);
            return this;
        }

        public R execute() {
            return this.execute(null);
        }

        public R execute(ExecutionOptions<R> options) {
            this.header("User-Agent", "OpenStack4j / OpenStack Client");
            HttpRequest<R> request = this.req.build();
            HttpResponse res = HttpExecutor.create().execute(request);
            reqIdContainer.remove();
            reqIdContainer.set(this.getRequestId(res));
            return res.getEntity(request.getReturnType(), options);
        }

        public HttpResponse executeWithResponse() {
            HttpResponse res = HttpExecutor.create().execute(this.req.build());
            reqIdContainer.remove();
            reqIdContainer.set(this.getRequestId(res));
            return res;
        }

        private String getRequestId(HttpResponse res) {
            if (res.headers().containsKey("X-Compute-Request-Id")) {
                return res.header("X-Compute-Request-Id");
            }
            return res.header("x-openstack-request-id");
        }
    }
}

