/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.manila.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.collect.Maps;
import org.openstack4j.model.manila.ExtraSpecs;
import org.openstack4j.model.manila.ShareTypeCreate;
import org.openstack4j.model.manila.builder.ShareTypeCreateBuilder;

@JsonRootName(value="share_type")
public class ManilaShareTypeCreate
implements ShareTypeCreate {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="extra_specs")
    ExtraSpecs extraSpecs;
    @JsonProperty(value="os-share-type-access:is_public")
    Boolean osShareTypeAccessIsPublic;
    String name;

    public static ShareTypeCreateBuilder builder() {
        return new ShareTypeCreateConcreteBuilder();
    }

    @Override
    public ExtraSpecs getExtraSpecs() {
        return this.extraSpecs;
    }

    @Override
    public Boolean getOsShareTypeAccessIsPublic() {
        return this.osShareTypeAccessIsPublic;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ShareTypeCreateBuilder toBuilder() {
        return new ShareTypeCreateConcreteBuilder(this);
    }

    public static class ShareTypeCreateConcreteBuilder
    implements ShareTypeCreateBuilder {
        ManilaShareTypeCreate shareTypeCreate;

        public ShareTypeCreateConcreteBuilder() {
            this(new ManilaShareTypeCreate());
        }

        public ShareTypeCreateConcreteBuilder(ManilaShareTypeCreate shareTypeCreate) {
            this.shareTypeCreate = shareTypeCreate;
        }

        @Override
        public ShareTypeCreateBuilder addExtraSpec(String key, String value) {
            if (this.shareTypeCreate.extraSpecs == null) {
                this.shareTypeCreate.extraSpecs = ExtraSpecs.toExtraSpecs(Maps.newHashMap());
            }
            this.shareTypeCreate.extraSpecs.put(key, value);
            return this;
        }

        @Override
        public ShareTypeCreateBuilder extraSpecs(ExtraSpecs extraSpecs) {
            this.shareTypeCreate.extraSpecs = extraSpecs;
            return this;
        }

        @Override
        public ShareTypeCreateBuilder osShareTypeAccessIsPublic(boolean osShareTypeAccessIsPublic) {
            this.shareTypeCreate.osShareTypeAccessIsPublic = osShareTypeAccessIsPublic;
            return this;
        }

        @Override
        public ShareTypeCreateBuilder name(String name) {
            this.shareTypeCreate.name = name;
            return this;
        }

        @Override
        public ShareTypeCreate build() {
            return this.shareTypeCreate;
        }

        @Override
        public ShareTypeCreateBuilder from(ShareTypeCreate in) {
            this.shareTypeCreate = (ManilaShareTypeCreate)in;
            return this;
        }
    }
}

