/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.manila.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.Apis;
import org.openstack4j.api.manila.QuotaSetService;
import org.openstack4j.api.manila.SchedulerStatsService;
import org.openstack4j.api.manila.SecurityServiceService;
import org.openstack4j.api.manila.ShareInstanceService;
import org.openstack4j.api.manila.ShareNetworkService;
import org.openstack4j.api.manila.ShareServerService;
import org.openstack4j.api.manila.ShareService;
import org.openstack4j.api.manila.ShareSnapshotService;
import org.openstack4j.api.manila.ShareTypeService;
import org.openstack4j.api.manila.SharesService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.common.Extension;
import org.openstack4j.model.manila.AvailabilityZone;
import org.openstack4j.model.manila.Limits;
import org.openstack4j.model.manila.Service;
import org.openstack4j.model.manila.Share;
import org.openstack4j.model.manila.ShareManage;
import org.openstack4j.openstack.common.ExtensionValue;
import org.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import org.openstack4j.openstack.manila.domain.ManilaAvailabilityZone;
import org.openstack4j.openstack.manila.domain.ManilaLimits;
import org.openstack4j.openstack.manila.domain.ManilaService;
import org.openstack4j.openstack.manila.domain.ManilaShare;
import org.openstack4j.openstack.manila.domain.actions.ServiceAction;
import org.openstack4j.openstack.manila.internal.BaseShareServices;

public class ShareServiceImpl
extends BaseShareServices
implements ShareService {
    @Override
    public List<? extends Extension> listExtensions() {
        return this.get(ExtensionValue.Extensions.class, this.uri("/extensions", new Object[0])).execute().getList();
    }

    @Override
    public Limits limits() {
        return this.get(ManilaLimits.class, this.uri("/limits", new Object[0])).execute();
    }

    @Override
    public SharesService shares() {
        return Apis.get(SharesService.class);
    }

    @Override
    public SecurityServiceService securityServices() {
        return Apis.get(SecurityServiceService.class);
    }

    @Override
    public ShareSnapshotService shareSnapshots() {
        return Apis.get(ShareSnapshotService.class);
    }

    @Override
    public ShareNetworkService shareNetworks() {
        return Apis.get(ShareNetworkService.class);
    }

    @Override
    public ShareServerService shareServers() {
        return Apis.get(ShareServerService.class);
    }

    @Override
    public ShareInstanceService shareInstances() {
        return Apis.get(ShareInstanceService.class);
    }

    @Override
    public ShareTypeService shareTypes() {
        return Apis.get(ShareTypeService.class);
    }

    @Override
    public SchedulerStatsService schedulerStats() {
        return Apis.get(SchedulerStatsService.class);
    }

    @Override
    public List<? extends Service> services() {
        return this.get(ManilaService.Services.class, this.uri("/os-services", new Object[0])).execute().getList();
    }

    @Override
    public ManilaService.ServiceStatus enableService(String binary, String host) {
        Preconditions.checkNotNull(binary);
        Preconditions.checkNotNull(host);
        return this.put(ManilaService.ServiceStatus.class, this.uri("/os-services/enable", new Object[0])).entity(ServiceAction.enable(binary, host)).execute();
    }

    @Override
    public ManilaService.ServiceStatus disableService(String binary, String host) {
        Preconditions.checkNotNull(binary);
        Preconditions.checkNotNull(host);
        return this.put(ManilaService.ServiceStatus.class, this.uri("/os-services/disable", new Object[0])).entity(ServiceAction.disable(binary, host)).execute();
    }

    @Override
    public List<? extends AvailabilityZone> availabilityZones() {
        return this.get(ManilaAvailabilityZone.AvailabilityZones.class, this.uri("/os-availability-zone", new Object[0])).execute().getList();
    }

    @Override
    public Share manageShare(ShareManage shareManage) {
        Preconditions.checkNotNull(shareManage);
        return this.post(ManilaShare.class, this.uri("/os-share-manage", new Object[0])).entity(shareManage).execute();
    }

    @Override
    public ActionResponse unmanageShare(String shareId) {
        Preconditions.checkNotNull(shareId);
        return ToActionResponseFunction.INSTANCE.apply(this.post(Void.class, this.uri("/os-share-unmanage/%s/unmanage", shareId)).executeWithResponse());
    }

    @Override
    public QuotaSetService quotaSets() {
        return Apis.get(QuotaSetService.class);
    }
}

