/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain.ext;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Map;
import org.openstack4j.model.network.ext.NetQosPolicy;
import org.openstack4j.model.network.ext.builder.NetQosPolicyBuilder;
import org.openstack4j.openstack.common.ListResult;

@JsonRootName(value="policy")
public class NeutronNetQosPolicy
implements NetQosPolicy {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private String description;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    @JsonProperty(value="project_id")
    private String projectId;
    @JsonProperty(value="revision_number")
    private String revisionNumber;
    @JsonProperty
    private boolean shared;
    @JsonProperty
    private String id;
    @JsonProperty(value="is_default")
    private boolean isDefault;
    @JsonProperty
    private List<Map<String, String>> rules;
    private String name;
    @JsonProperty
    private List<String> tags;

    public static NetQosPolicyBuilder builder() {
        return new NetQosPolicyConcreteBuilder();
    }

    @Override
    public NetQosPolicyBuilder toBuilder() {
        return new NetQosPolicyConcreteBuilder(this);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getRevisionNumber() {
        return this.revisionNumber;
    }

    @Override
    public boolean isShared() {
        return this.shared;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public List<Map<String, String>> getRules() {
        return this.rules;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("description", this.description).add("tenantId", this.tenantId).add("shared", this.shared).add("isDefault", this.isDefault).add("name", this.name).add("rules", this.rules).add("tags", this.tags).toString();
    }

    public static class NeutronNetQosPolicies
    extends ListResult<NeutronNetQosPolicy> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="policies")
        private List<NeutronNetQosPolicy> policies;

        @Override
        protected List<NeutronNetQosPolicy> value() {
            return this.policies;
        }
    }

    public static class NetQosPolicyConcreteBuilder
    implements NetQosPolicyBuilder {
        private NeutronNetQosPolicy model;

        public NetQosPolicyConcreteBuilder() {
            this.model = new NeutronNetQosPolicy();
        }

        public NetQosPolicyConcreteBuilder(NeutronNetQosPolicy model) {
            this.model = model;
        }

        @Override
        public NetQosPolicy build() {
            return this.model;
        }

        @Override
        public NetQosPolicyBuilder from(NetQosPolicy in) {
            this.model = (NeutronNetQosPolicy)in;
            return this;
        }

        @Override
        public NetQosPolicyBuilder description(String description) {
            this.model.description = description;
            return this;
        }

        @Override
        public NetQosPolicyBuilder tenantId(String tenantId) {
            this.model.tenantId = tenantId;
            return this;
        }

        @Override
        public NetQosPolicyBuilder shared(boolean shared) {
            this.model.shared = shared;
            return this;
        }

        @Override
        public NetQosPolicyBuilder isDefault(boolean isDefault) {
            this.model.isDefault = isDefault;
            return this;
        }

        @Override
        public NetQosPolicyBuilder name(String name) {
            this.model.name = name;
            return this;
        }
    }
}

