/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain.ext;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import java.util.List;
import org.openstack4j.model.network.ext.Protocol;
import org.openstack4j.model.network.ext.SessionPersistence;
import org.openstack4j.model.network.ext.Vip;
import org.openstack4j.model.network.ext.builder.VipBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.networking.domain.ext.NeutronSessionPersistence;

@JsonRootName(value="vip")
@JsonIgnoreProperties(ignoreUnknown=true)
public class NeutronVip
implements Vip {
    private static final long serialVersionUID = 1L;
    private String id;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    private String name;
    private String description;
    @JsonProperty(value="subnet_id")
    private String subnetId;
    private String address;
    private Protocol protocol;
    @JsonProperty(value="protocol_port")
    private Integer protocolPort;
    @JsonProperty(value="pool_id")
    private String poolId;
    @JsonProperty(value="session_persistence")
    private NeutronSessionPersistence sessionPersistence;
    @JsonProperty(value="connection_limit")
    private Integer connectionLimit;
    @JsonProperty(value="admin_state_up")
    private boolean adminStateUp;
    private String status;

    public static VipBuilder builder() {
        return new VipContreteBuilder();
    }

    @Override
    public VipBuilder toBuilder() {
        return new VipContreteBuilder();
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public boolean isAdminStateUp() {
        return this.adminStateUp;
    }

    @Override
    public Integer getConnectionLimit() {
        return this.connectionLimit;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPoolId() {
        return this.poolId;
    }

    @Override
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public Integer getProtocolPort() {
        return this.protocolPort;
    }

    @Override
    public SessionPersistence getSessionPersistence() {
        return this.sessionPersistence;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public String getSubnetId() {
        return this.subnetId;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("address", this.address).add("adminStateUp", this.adminStateUp).add("connectionLimit", this.connectionLimit).add("description", this.description).add("id", this.id).add("name", this.name).add("poolId", this.poolId).add("protocol", (Object)this.protocol).add("protocolPort", this.protocolPort).add("status", this.status).add("subnetId", this.subnetId).add("tenantId", this.tenantId).add("sessionPersistence", this.sessionPersistence).toString();
    }

    public static class VipContreteBuilder
    implements VipBuilder {
        private NeutronVip m;

        public VipContreteBuilder() {
            this(new NeutronVip());
        }

        public VipContreteBuilder(NeutronVip m) {
            this.m = m;
        }

        @Override
        public Vip build() {
            return this.m;
        }

        @Override
        public VipBuilder from(Vip in) {
            this.m = (NeutronVip)in;
            return this;
        }

        @Override
        public VipBuilder tenantId(String tenantId) {
            this.m.tenantId = tenantId;
            return this;
        }

        @Override
        public VipBuilder name(String name) {
            this.m.name = name;
            return this;
        }

        @Override
        public VipBuilder description(String description) {
            this.m.description = description;
            return this;
        }

        @Override
        public VipBuilder subnetId(String subnetId) {
            this.m.subnetId = subnetId;
            return this;
        }

        @Override
        public VipBuilder address(String address) {
            this.m.address = address;
            return this;
        }

        @Override
        public VipBuilder protocol(Protocol protocol) {
            this.m.protocol = protocol;
            return this;
        }

        @Override
        public VipBuilder protocolPort(Integer protocolPort) {
            this.m.protocolPort = protocolPort;
            return this;
        }

        @Override
        public VipBuilder poolId(String poolId) {
            this.m.poolId = poolId;
            return this;
        }

        @Override
        public VipBuilder sessionPersistence(SessionPersistence sessionPersistence) {
            this.m.sessionPersistence = (NeutronSessionPersistence)sessionPersistence;
            return this;
        }

        @Override
        public VipBuilder connectionLimit(Integer connectionLimit) {
            this.m.connectionLimit = connectionLimit;
            return this;
        }

        @Override
        public VipBuilder adminStateUp(boolean adminStateUp) {
            this.m.adminStateUp = adminStateUp;
            return this;
        }
    }

    public static class Vips
    extends ListResult<NeutronVip> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="vips")
        List<NeutronVip> vips;

        @Override
        public List<NeutronVip> value() {
            return this.vips;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).omitNullValues().add("vips", this.vips).toString();
        }
    }
}

