/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.openstack4j.api.networking.SecurityGroupRuleService;
import org.openstack4j.model.network.SecurityGroupRule;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.networking.domain.NeutronSecurityGroupRule;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class SecurityGroupRuleServiceImpl
extends BaseNetworkingServices
implements SecurityGroupRuleService {
    @Override
    public SecurityGroupRule get(String id) {
        Preconditions.checkNotNull(id);
        return this.get(NeutronSecurityGroupRule.class, this.uri("/security-group-rules/%s", id)).execute();
    }

    @Override
    public void delete(String ruleId) {
        Preconditions.checkNotNull(ruleId);
        this.delete(Void.class, this.uri("/security-group-rules/%s", ruleId)).execute();
    }

    @Override
    public SecurityGroupRule create(SecurityGroupRule rule) {
        Preconditions.checkNotNull(rule);
        return this.post(NeutronSecurityGroupRule.class, this.uri("/security-group-rules", new Object[0])).entity(rule).execute();
    }

    @Override
    public List<? extends SecurityGroupRule> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NeutronSecurityGroupRule.SecurityGroupRules> securityGroupRulesInvocation = this.get(NeutronSecurityGroupRule.SecurityGroupRules.class, "/security-group-rules");
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                securityGroupRulesInvocation = securityGroupRulesInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return securityGroupRulesInvocation.execute().getList();
    }

    @Override
    public List<? extends SecurityGroupRule> list() {
        return this.get(NeutronSecurityGroupRule.SecurityGroupRules.class, this.uri("/security-group-rules", new Object[0])).execute().getList();
    }
}

