/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.internal.ext;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.openstack4j.api.networking.ext.FirewallService;
import org.openstack4j.core.transport.ExecutionOptions;
import org.openstack4j.core.transport.propagation.PropagateOnStatus;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.ext.Firewall;
import org.openstack4j.model.network.ext.FirewallUpdate;
import org.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.networking.domain.ext.NeutronFirewall;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class FirewallServiceImpl
extends BaseNetworkingServices
implements FirewallService {
    @Override
    public List<? extends Firewall> list() {
        return this.get(NeutronFirewall.Firewalls.class, this.uri("/fw/firewalls", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends Firewall> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NeutronFirewall.Firewalls> req = this.get(NeutronFirewall.Firewalls.class, this.uri("/fw/firewalls", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public Firewall get(String firewallId) {
        Preconditions.checkNotNull(firewallId);
        return this.get(NeutronFirewall.class, this.uri("/fw/firewalls/%s", firewallId)).execute();
    }

    @Override
    public ActionResponse delete(String firewallId) {
        Preconditions.checkNotNull(firewallId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/fw/firewalls/%s", firewallId)).executeWithResponse());
    }

    @Override
    public Firewall create(Firewall firewall) {
        return this.post(NeutronFirewall.class, this.uri("/fw/firewalls", new Object[0])).entity(firewall).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }

    @Override
    public Firewall update(String firewallId, FirewallUpdate firewallUpdate) {
        Preconditions.checkNotNull(firewallId);
        Preconditions.checkNotNull(firewallUpdate);
        return this.put(NeutronFirewall.class, this.uri("/fw/firewalls/%s", firewallId)).entity(firewallUpdate).execute();
    }
}

