/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.internal.ext;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.openstack4j.api.networking.ext.HealthMonitorService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.ext.HealthMonitor;
import org.openstack4j.model.network.ext.HealthMonitorUpdate;
import org.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.networking.domain.ext.NeutronHealthMonitor;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class HealthMonitorServiceImpl
extends BaseNetworkingServices
implements HealthMonitorService {
    @Override
    public List<? extends HealthMonitor> list() {
        return this.get(NeutronHealthMonitor.HealthMonitors.class, this.uri("/lb/health_monitors", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends HealthMonitor> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NeutronHealthMonitor.HealthMonitors> req = this.get(NeutronHealthMonitor.HealthMonitors.class, this.uri("/lb/health_monitors", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public HealthMonitor get(String healthMonitorId) {
        Preconditions.checkNotNull(healthMonitorId);
        return this.get(NeutronHealthMonitor.class, this.uri("/lb/health_monitors/%s", healthMonitorId)).execute();
    }

    @Override
    public ActionResponse delete(String healthMonitorId) {
        Preconditions.checkNotNull(healthMonitorId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/lb/health_monitors/%s", healthMonitorId)).executeWithResponse());
    }

    @Override
    public HealthMonitor create(HealthMonitor healthMonitor) {
        Preconditions.checkNotNull(healthMonitor);
        return this.post(NeutronHealthMonitor.class, this.uri("/lb/health_monitors", new Object[0])).entity(healthMonitor).execute();
    }

    @Override
    public HealthMonitor update(String healthMonitorId, HealthMonitorUpdate healthMonitor) {
        Preconditions.checkNotNull(healthMonitorId);
        Preconditions.checkNotNull(healthMonitor);
        return this.put(NeutronHealthMonitor.class, this.uri("/lb/health_monitors/%s", healthMonitorId)).entity(healthMonitor).execute();
    }
}

