/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.internal.ext;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.networking.ext.NetQosPolicyService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.ext.NetQosPolicy;
import org.openstack4j.model.network.ext.NetQosPolicyUpdate;
import org.openstack4j.openstack.networking.domain.ext.NeutronNetQosPolicy;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class NetQosPolicyServiceImpl
extends BaseNetworkingServices
implements NetQosPolicyService {
    @Override
    public List<? extends NetQosPolicy> list() {
        return this.get(NeutronNetQosPolicy.NeutronNetQosPolicies.class, this.uri("/qos/policies", new Object[0])).execute().getList();
    }

    @Override
    public NetQosPolicy get(String policyId) {
        Preconditions.checkNotNull(policyId, "qos policyId must not be null");
        return this.get(NeutronNetQosPolicy.class, this.uri("/qos/policies/%s", policyId)).execute();
    }

    @Override
    public NetQosPolicy update(NetQosPolicyUpdate update) {
        Preconditions.checkNotNull(update, "netQosPolicy must not be null");
        Preconditions.checkNotNull(update.getId(), "netQosPolicy id must not be null");
        return this.put(NeutronNetQosPolicy.class, this.uri("/qos/policies/%s", this.getAndClearIdentifier(update))).entity(update).execute();
    }

    @Override
    public NetQosPolicy create(NetQosPolicy netQosPolicy) {
        Preconditions.checkNotNull(netQosPolicy, "netQosPolicy must not be null");
        return this.post(NeutronNetQosPolicy.class, this.uri("/qos/policies", new Object[0])).entity(netQosPolicy).execute();
    }

    @Override
    public ActionResponse delete(String policyId) {
        Preconditions.checkNotNull(policyId);
        return this.deleteWithResponse(this.uri("/qos/policies/%s", policyId)).execute();
    }

    private String getAndClearIdentifier(NetQosPolicyUpdate update) {
        String id = update.getId();
        update.setId(null);
        return id;
    }
}

