/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.octavia.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import org.openstack4j.model.octavia.HealthMonitorV2Update;
import org.openstack4j.model.octavia.builder.HealthMonitorV2UpdateBuilder;

@JsonRootName(value="healthmonitor")
@JsonIgnoreProperties(ignoreUnknown=true)
public class OctaviaHealthMonitorV2Update
implements HealthMonitorV2Update {
    private static final long serialVersionUID = 1L;
    private Integer delay;
    private Integer timeout;
    @JsonProperty(value="max_retries")
    private Integer maxRetries;
    @JsonProperty(value="max_retries_down")
    private Integer maxRetriesDown;
    @JsonProperty(value="http_method")
    private String httpMethod;
    @JsonProperty(value="url_path")
    private String urlPath;
    @JsonProperty(value="expected_codes")
    private String expectedCodes;
    @JsonProperty(value="admin_state_up")
    private boolean adminStateUp = true;

    public static HealthMonitorV2UpdateBuilder builder() {
        return new HealthMonitorV2UpdateConcreteBuilder();
    }

    @Override
    public Integer getDelay() {
        return this.delay;
    }

    @Override
    public String getUrlPath() {
        return this.urlPath;
    }

    @Override
    public Integer getTimeout() {
        return this.timeout;
    }

    @Override
    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    @Override
    public Integer getMaxRetriesDown() {
        return this.maxRetriesDown;
    }

    @Override
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public String getExpectedCodes() {
        return this.expectedCodes;
    }

    @Override
    public boolean isAdminStateUp() {
        return this.adminStateUp;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("delay", this.delay).add("urlPath", this.urlPath).add("adminStateUp", this.adminStateUp).add("expectedCodes", this.expectedCodes).add("httpMethod", this.httpMethod).add("maxRetries", this.maxRetries).add("maxRetriesDown", this.maxRetriesDown).add("timeout", this.timeout).toString();
    }

    @Override
    public HealthMonitorV2UpdateBuilder toBuilder() {
        return new HealthMonitorV2UpdateConcreteBuilder(this);
    }

    public static class HealthMonitorV2UpdateConcreteBuilder
    implements HealthMonitorV2UpdateBuilder {
        OctaviaHealthMonitorV2Update m;

        public HealthMonitorV2UpdateConcreteBuilder() {
            this(new OctaviaHealthMonitorV2Update());
        }

        public HealthMonitorV2UpdateConcreteBuilder(OctaviaHealthMonitorV2Update m) {
            this.m = m;
        }

        @Override
        public HealthMonitorV2Update build() {
            return this.m;
        }

        @Override
        public HealthMonitorV2UpdateBuilder from(HealthMonitorV2Update in) {
            this.m = (OctaviaHealthMonitorV2Update)in;
            return this;
        }

        @Override
        public HealthMonitorV2UpdateBuilder delay(Integer delay) {
            this.m.delay = delay;
            return this;
        }

        @Override
        public HealthMonitorV2UpdateBuilder urlPath(String urlPath) {
            this.m.urlPath = urlPath;
            return this;
        }

        @Override
        public HealthMonitorV2UpdateBuilder expectedCodes(String expectedCodes) {
            this.m.expectedCodes = expectedCodes;
            return this;
        }

        @Override
        public HealthMonitorV2UpdateBuilder httpMethod(String httpMethod) {
            this.m.httpMethod = httpMethod;
            return this;
        }

        @Override
        public HealthMonitorV2UpdateBuilder maxRetries(Integer maxRetries) {
            this.m.maxRetries = maxRetries;
            return this;
        }

        @Override
        public HealthMonitorV2UpdateBuilder maxRetriesDown(Integer maxRetriesDown) {
            this.m.maxRetriesDown = maxRetriesDown;
            return this;
        }

        @Override
        public HealthMonitorV2UpdateBuilder adminStateUp(boolean adminStateUp) {
            this.m.adminStateUp = adminStateUp;
            return this;
        }

        @Override
        public HealthMonitorV2UpdateBuilder timeout(Integer timeout) {
            this.m.timeout = timeout;
            return this;
        }
    }
}

