/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.sahara.internal;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.util.List;
import org.openstack4j.api.sahara.JobBinaryService;
import org.openstack4j.core.transport.HttpEntityHandler;
import org.openstack4j.core.transport.HttpResponse;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.common.Payload;
import org.openstack4j.model.common.Payloads;
import org.openstack4j.model.sahara.JobBinary;
import org.openstack4j.openstack.sahara.domain.SaharaJobBinary;
import org.openstack4j.openstack.sahara.domain.SaharaJobBinaryUnwrapped;
import org.openstack4j.openstack.sahara.internal.BaseSaharaServices;

public class JobBinaryServiceImpl
extends BaseSaharaServices
implements JobBinaryService {
    @Override
    public List<? extends JobBinary> list() {
        return this.get(SaharaJobBinary.JobBinaries.class, this.uri("/job-binaries", new Object[0])).execute().getList();
    }

    @Override
    public JobBinary get(String JobBinaryId) {
        Preconditions.checkNotNull(JobBinaryId);
        return this.get(SaharaJobBinary.class, this.uri("/job-binaries/%s", JobBinaryId)).execute();
    }

    @Override
    public JobBinary create(JobBinary jobBinary) {
        Preconditions.checkNotNull(jobBinary);
        SaharaJobBinaryUnwrapped unwrapped = new SaharaJobBinaryUnwrapped(jobBinary);
        return this.post(SaharaJobBinary.class, this.uri("/job-binaries", new Object[0])).entity(unwrapped).execute();
    }

    @Override
    public ActionResponse delete(String JobBinaryId) {
        Preconditions.checkNotNull(JobBinaryId);
        return this.deleteWithResponse(this.uri("/job-binaries/%s", JobBinaryId)).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Payload<InputStream> getData(String JobBinaryId) {
        HttpResponse response = this.get(Void.class, this.uri("/job-binaries/%s/data", JobBinaryId)).executeWithResponse();
        try {
            if (response.getStatus() < 400) {
                Payload<InputStream> payload = Payloads.create(response.getInputStream());
                return payload;
            }
            Payload<InputStream> payload = null;
            return payload;
        }
        finally {
            HttpEntityHandler.closeQuietly(response);
        }
    }
}

