/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.sahara.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.sahara.SaharaPluginService;
import org.openstack4j.core.transport.ExecutionOptions;
import org.openstack4j.core.transport.propagation.PropagateOnStatus;
import org.openstack4j.model.common.Payload;
import org.openstack4j.model.sahara.ClusterTemplate;
import org.openstack4j.model.sahara.Plugin;
import org.openstack4j.openstack.sahara.domain.SaharaClusterTemplate;
import org.openstack4j.openstack.sahara.domain.SaharaPlugin;
import org.openstack4j.openstack.sahara.internal.BaseSaharaServices;

public class SaharaPluginServiceImpl
extends BaseSaharaServices
implements SaharaPluginService {
    @Override
    public List<? extends Plugin> list() {
        return this.get(SaharaPlugin.SaharaPlugins.class, this.uri("/plugins", new Object[0])).execute().getList();
    }

    @Override
    public Plugin get(String name) {
        Preconditions.checkNotNull(name);
        return this.get(SaharaPlugin.class, this.uri("/plugins/%s", name)).execute();
    }

    @Override
    public Plugin get(String name, String version) {
        Preconditions.checkNotNull(name);
        Preconditions.checkNotNull(version);
        return this.get(SaharaPlugin.class, this.uri("/plugins/%s/%s", name, version)).execute();
    }

    @Override
    public ClusterTemplate convertConfig(String name, String version, String templateName, Payload<?> payload) {
        Preconditions.checkNotNull(name);
        Preconditions.checkNotNull(version);
        Preconditions.checkNotNull(templateName);
        return this.post(SaharaClusterTemplate.class, this.uri("/plugins/%s/%s/convert-config/%s", name, version, templateName)).entity(payload).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }
}

