/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.storage.block.internal;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.openstack4j.api.storage.BlockVolumeBackupService;
import org.openstack4j.model.ModelEntity;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.storage.block.VolumeBackup;
import org.openstack4j.model.storage.block.VolumeBackupCreate;
import org.openstack4j.model.storage.block.VolumeBackupRestore;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.storage.block.domain.CinderVolumeBackup;
import org.openstack4j.openstack.storage.block.domain.CinderVolumeBackupRestore;
import org.openstack4j.openstack.storage.block.internal.BaseBlockStorageServices;

public class BlockVolumeBackupServiceImpl
extends BaseBlockStorageServices
implements BlockVolumeBackupService {
    @Override
    public List<? extends VolumeBackup> list() {
        return this.get(CinderVolumeBackup.VolumeBackups.class, this.uri("/backups/detail", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends VolumeBackup> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<CinderVolumeBackup.VolumeBackups> invocation = this.buildInvocation(filteringParams);
        return invocation.execute().getList();
    }

    private BaseOpenStackService.Invocation<CinderVolumeBackup.VolumeBackups> buildInvocation(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<CinderVolumeBackup.VolumeBackups> invocation = this.get(CinderVolumeBackup.VolumeBackups.class, "/backups/detail");
        if (filteringParams == null) {
            return invocation;
        }
        for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
            invocation = invocation.param(entry.getKey(), entry.getValue());
        }
        return invocation;
    }

    @Override
    public VolumeBackup get(String backupId) {
        Preconditions.checkNotNull(backupId);
        return this.get(CinderVolumeBackup.class, this.uri("/backups/%s", backupId)).execute();
    }

    @Override
    public ActionResponse delete(String backupId) {
        Preconditions.checkNotNull(backupId);
        return this.deleteWithResponse(this.uri("/backups/%s", backupId)).execute();
    }

    @Override
    public VolumeBackup create(VolumeBackupCreate vbc) {
        Preconditions.checkNotNull(vbc);
        Preconditions.checkNotNull(vbc.getVolumeId());
        return this.post(CinderVolumeBackup.class, this.uri("/backups", new Object[0])).entity(vbc).execute();
    }

    @Override
    public VolumeBackupRestore restore(String backupId, String name, String volumeId) {
        _VolumeBackupRestore entity = new _VolumeBackupRestore(name, volumeId);
        return this.post(CinderVolumeBackupRestore.class, this.uri("/backups/%s/restore", backupId)).entity(entity).execute();
    }

    @JsonRootName(value="restore")
    private static class _VolumeBackupRestore
    implements ModelEntity {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="volume_id")
        private String volumeId;

        public _VolumeBackupRestore(String name, String volumeId) {
            this.name = name;
            this.volumeId = volumeId;
        }
    }
}

