/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.telemetry.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.telemetry.EventService;
import org.openstack4j.model.telemetry.Event;
import org.openstack4j.model.telemetry.EventCriteria;
import org.openstack4j.model.telemetry.Trait;
import org.openstack4j.model.telemetry.TraitDescription;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.telemetry.domain.CeilometerEvent;
import org.openstack4j.openstack.telemetry.domain.CeilometerTrait;
import org.openstack4j.openstack.telemetry.domain.CeilometerTraitDescription;
import org.openstack4j.openstack.telemetry.internal.BaseTelemetryServices;

public class EventServiceImpl
extends BaseTelemetryServices
implements EventService {
    private static final String FIELD = "q.field";
    private static final String OPER = "q.op";
    private static final String VALUE = "q.value";
    private static final String LIMIT = "limit";

    @Override
    public List<? extends Event> list(EventCriteria eventCriteria) {
        BaseOpenStackService.Invocation<CeilometerEvent[]> invocation = this.get(CeilometerEvent[].class, this.uri("/events", new Object[0]));
        if (eventCriteria != null && !eventCriteria.getCriteriaParams().isEmpty()) {
            for (EventCriteria.NameOpValue c : eventCriteria.getCriteriaParams()) {
                invocation.param(FIELD, c.getField());
                invocation.param(OPER, c.getOperator().getQueryValue());
                invocation.param(VALUE, c.getValue());
            }
        }
        CeilometerEvent[] events = invocation.execute();
        return this.wrapList(events);
    }

    @Override
    public List<? extends Event> list(EventCriteria eventCriteria, int limit) {
        BaseOpenStackService.Invocation<CeilometerEvent[]> invocation = this.get(CeilometerEvent[].class, this.uri("/events", new Object[0]));
        if (eventCriteria != null && !eventCriteria.getCriteriaParams().isEmpty()) {
            for (EventCriteria.NameOpValue c : eventCriteria.getCriteriaParams()) {
                invocation.param(FIELD, c.getField());
                invocation.param(OPER, c.getOperator().getQueryValue());
                invocation.param(VALUE, c.getValue());
            }
        }
        invocation.param(LIMIT, limit);
        CeilometerEvent[] events = invocation.execute();
        return this.wrapList(events);
    }

    @Override
    public Event get(String messageId) {
        Preconditions.checkNotNull(messageId);
        return this.get(CeilometerEvent.class, this.uri("/events/%s", messageId)).execute();
    }

    @Override
    public List<String> listEventTypes() {
        String[] eventTypes = this.get(String[].class, this.uri("/event_types", new Object[0])).execute();
        return this.wrapList(eventTypes);
    }

    @Override
    public List<? extends TraitDescription> listTraitDescriptions(String eventType) {
        Preconditions.checkNotNull(eventType);
        CeilometerTraitDescription[] traitDescriptions = this.get(CeilometerTraitDescription[].class, this.uri("/event_types/%s/traits", eventType)).execute();
        return this.wrapList(traitDescriptions);
    }

    @Override
    public List<? extends Trait> listTraits(String eventType, String traitName) {
        Preconditions.checkNotNull(eventType);
        Preconditions.checkNotNull(traitName);
        CeilometerTrait[] traits = this.get(CeilometerTrait[].class, this.uri("/event_types/%s/traits/%s", eventType, traitName)).execute();
        return this.wrapList(traits);
    }
}

