/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.trove.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.Date;
import java.util.List;
import org.openstack4j.model.trove.Flavor;
import org.openstack4j.model.trove.Instance;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.trove.domain.TroveInstanceFlavor;

@JsonRootName(value="instance")
public class TroveInstance
implements Instance {
    private static final long serialVersionUID = 1L;
    private Date created;
    private TroveInstanceFlavor flavor;
    private String hostname;
    private List<String> ip;
    private String id;
    private String name;
    private String status;
    private Date updated;
    private Volume volume;
    private InstanceDatastore datastore;

    @Override
    public int getVolumeSize() {
        return this.getVolume().getSize();
    }

    @Override
    public String getVolumeType() {
        return this.getVolume().getType();
    }

    @Override
    public Flavor getFlavor() {
        return this.flavor;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public List<String> getIp() {
        return this.ip;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public Date getUpdated() {
        return this.updated;
    }

    public Volume getVolume() {
        return this.volume;
    }

    public InstanceDatastore getDatastore() {
        return this.datastore;
    }

    @Override
    public String getDatastoreType() {
        return this.getDatastore() != null ? this.getDatastore().getType() : null;
    }

    @Override
    public String getDatastoreVersion() {
        return this.getDatastore() != null ? this.getDatastore().getVersion() : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TroveInstance{");
        sb.append("created=").append(this.created);
        sb.append(", flavor=").append(this.flavor);
        sb.append(", hostname='").append(this.hostname).append('\'');
        sb.append(", ip='").append(this.ip).append('\'');
        sb.append(", id='").append(this.id).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", status='").append(this.status).append('\'');
        sb.append(", updated=").append(this.updated);
        sb.append(", volume=").append(this.volume);
        sb.append(", datastore=").append(this.datastore);
        sb.append('}');
        return sb.toString();
    }

    public class InstanceDatastore {
        private String type;
        private String version;

        public String getType() {
            return this.type;
        }

        public String getVersion() {
            return this.version;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("InstanceDatastore{");
            sb.append("type='").append(this.type).append('\'');
            sb.append(", version='").append(this.version).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }

    public class Volume {
        private String type;
        private Integer size;

        public String getType() {
            return this.type;
        }

        public int getSize() {
            return this.size;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Volume{");
            sb.append("type='").append(this.type).append('\'');
            sb.append(", size=").append(this.size);
            sb.append('}');
            return sb.toString();
        }
    }

    public static class DBInstances
    extends ListResult<TroveInstance> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="instances")
        private List<TroveInstance> instances;

        @Override
        protected List<TroveInstance> value() {
            return this.instances;
        }
    }
}

