/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openstack.cinder.producer;

import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.openstack.cinder.CinderEndpoint;
import org.apache.camel.component.openstack.common.AbstractOpenstackProducer;
import org.apache.camel.util.StringHelper;
import org.openstack4j.api.Builders;
import org.openstack4j.api.OSClient;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.storage.block.VolumeSnapshot;
import org.openstack4j.model.storage.block.builder.VolumeSnapshotBuilder;

public class SnapshotProducer
extends AbstractOpenstackProducer {
    public SnapshotProducer(CinderEndpoint endpoint, OSClient client) {
        super(endpoint, client);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = this.getOperation(exchange)) {
            case "create": {
                this.doCreate(exchange);
                break;
            }
            case "get": {
                this.doGet(exchange);
                break;
            }
            case "getAll": {
                this.doGetAll(exchange);
                break;
            }
            case "update": {
                this.doUpdate(exchange);
                break;
            }
            case "delete": {
                this.doDelete(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    private void doCreate(Exchange exchange) {
        Message msg = exchange.getIn();
        VolumeSnapshot in = this.messageToSnapshot(msg);
        VolumeSnapshot out = this.os.blockStorage().snapshots().create(in);
        msg.setBody(out);
    }

    private void doGet(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = msg.getHeader("ID", msg.getHeader("snapshotId", String.class), String.class);
        StringHelper.notEmpty(id, "Snapshot ID");
        VolumeSnapshot out = this.os.blockStorage().snapshots().get(id);
        msg.setBody(out);
    }

    private void doGetAll(Exchange exchange) {
        List<? extends VolumeSnapshot> out = this.os.blockStorage().snapshots().list();
        exchange.getIn().setBody(out);
    }

    private void doUpdate(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = msg.getHeader("ID", msg.getHeader("snapshotId", String.class), String.class);
        VolumeSnapshot vs = this.messageToSnapshot(msg);
        StringHelper.notEmpty(id, "Cinder Snapshot ID");
        ActionResponse out = this.os.blockStorage().snapshots().update(id, vs.getName(), vs.getDescription());
        this.checkFailure(out, exchange, "Update volume snapshot " + id);
    }

    private void doDelete(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = msg.getHeader("ID", msg.getHeader("snapshotId", String.class), String.class);
        StringHelper.notEmpty(id, "Cinder Snapshot ID");
        ActionResponse out = this.os.blockStorage().snapshots().delete(id);
        this.checkFailure(out, exchange, "Delete snapshot " + id);
    }

    private VolumeSnapshot messageToSnapshot(Message message) {
        VolumeSnapshot volume = message.getBody(VolumeSnapshot.class);
        if (volume == null) {
            Map<String, Object> headers = message.getHeaders();
            VolumeSnapshotBuilder builder = Builders.volumeSnapshot();
            String name = message.getHeader("name", String.class);
            StringHelper.notEmpty(name, "Name");
            builder.name(name);
            if (headers.containsKey("description")) {
                builder.description(message.getHeader("description", String.class));
            }
            if (headers.containsKey("volumeId")) {
                builder.volume(message.getHeader("volumeId", String.class));
            }
            if (headers.containsKey("force")) {
                builder.force(message.getHeader("force", Boolean.class));
            }
            volume = (VolumeSnapshot)builder.build();
        }
        return volume;
    }
}

