/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openstack.cinder.producer;

import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.openstack.cinder.CinderEndpoint;
import org.apache.camel.component.openstack.common.AbstractOpenstackProducer;
import org.apache.camel.util.StringHelper;
import org.openstack4j.api.Builders;
import org.openstack4j.api.OSClient;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.storage.block.Volume;
import org.openstack4j.model.storage.block.VolumeType;
import org.openstack4j.model.storage.block.builder.VolumeBuilder;

public class VolumeProducer
extends AbstractOpenstackProducer {
    public VolumeProducer(CinderEndpoint endpoint, OSClient client) {
        super(endpoint, client);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = this.getOperation(exchange)) {
            case "create": {
                this.doCreate(exchange);
                break;
            }
            case "get": {
                this.doGet(exchange);
                break;
            }
            case "getAll": {
                this.doGetAll(exchange);
                break;
            }
            case "getAllTypes": {
                this.doGetAllTypes(exchange);
                break;
            }
            case "update": {
                this.doUpdate(exchange);
                break;
            }
            case "delete": {
                this.doDelete(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    private void doCreate(Exchange exchange) {
        Message msg = exchange.getIn();
        Volume in = this.messageToVolume(msg);
        Volume out = this.os.blockStorage().volumes().create(in);
        msg.setBody(out);
    }

    private void doGet(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = msg.getHeader("ID", msg.getHeader("volumeId", String.class), String.class);
        StringHelper.notEmpty(id, "Volume ID");
        Volume out = this.os.blockStorage().volumes().get(id);
        msg.setBody(out);
    }

    private void doGetAll(Exchange exchange) {
        List<? extends Volume> out = this.os.blockStorage().volumes().list();
        exchange.getIn().setBody(out);
    }

    private void doGetAllTypes(Exchange exchange) {
        List<? extends VolumeType> out = this.os.blockStorage().volumes().listVolumeTypes();
        exchange.getIn().setBody(out);
    }

    private void doUpdate(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = msg.getHeader("ID", msg.getHeader("volumeId", String.class), String.class);
        Volume vol = this.messageToVolume(msg);
        StringHelper.notEmpty(id, "Cinder Volume ID");
        StringHelper.notEmpty(vol.getDescription(), "Cinder Volume Description");
        StringHelper.notEmpty(vol.getName(), "Cinder Volume Name");
        ActionResponse out = this.os.blockStorage().volumes().update(id, vol.getName(), vol.getDescription());
        this.checkFailure(out, exchange, "Update volume " + id);
    }

    private void doDelete(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = msg.getHeader("ID", msg.getHeader("volumeId", String.class), String.class);
        StringHelper.notEmpty(id, "Cinder Volume ID");
        ActionResponse out = this.os.blockStorage().volumes().delete(id);
        this.checkFailure(out, exchange, "Delete volume " + id);
    }

    private Volume messageToVolume(Message message) {
        Volume volume = message.getBody(Volume.class);
        if (volume == null) {
            Map<String, Object> headers = message.getHeaders();
            VolumeBuilder builder = Builders.volume();
            String name = message.getHeader("name", String.class);
            StringHelper.notEmpty(name, "Name ");
            builder.name(name);
            if (headers.containsKey("description")) {
                builder.description(message.getHeader("description", String.class));
            }
            if (headers.containsKey("size")) {
                builder.size(message.getHeader("size", Integer.class));
            }
            if (headers.containsKey("volumeType")) {
                builder.volumeType(message.getHeader("volumeType", String.class));
            }
            if (headers.containsKey("imageRef")) {
                builder.imageRef(message.getHeader("imageRef", String.class));
            }
            if (headers.containsKey("snapshotId")) {
                builder.snapshot(message.getHeader("snapshotId", String.class));
            }
            if (headers.containsKey("isBootable")) {
                builder.bootable(message.getHeader("isBootable", Boolean.class));
            }
            volume = (Volume)builder.build();
        }
        return volume;
    }
}

