/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openstack.common;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.openstack.common.AbstractOpenstackEndpoint;
import org.apache.camel.component.openstack.common.OpenstackOperationException;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.openstack4j.api.OSClient;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.common.Payload;
import org.openstack4j.model.common.Payloads;

public abstract class AbstractOpenstackProducer
extends DefaultProducer {
    protected OSClient os;
    private AbstractOpenstackEndpoint endpoint;

    public AbstractOpenstackProducer(AbstractOpenstackEndpoint endpoint, OSClient client) {
        super(endpoint);
        this.os = client;
        this.endpoint = endpoint;
    }

    protected Payload createPayload(Message msg) {
        Payload<Object> payload = msg.getBody(Payload.class);
        if (ObjectHelper.isNotEmpty(payload)) {
            return payload;
        }
        Object messageBody = msg.getBody();
        if (messageBody instanceof URL) {
            payload = Payloads.create((URL)messageBody);
        }
        if (messageBody instanceof File) {
            payload = Payloads.create((File)messageBody);
        }
        if (messageBody instanceof InputStream) {
            payload = Payloads.create((InputStream)messageBody);
        }
        if (payload == null) {
            throw new IllegalArgumentException("You have to set payload. It can be InputStream, File or URL class");
        }
        return payload;
    }

    protected String getOperation(Exchange exchange) {
        String operation = exchange.getIn().getHeader("operation", this.endpoint.getOperation(), String.class);
        StringHelper.notEmpty(operation, "Operation");
        return operation;
    }

    protected void checkFailure(ActionResponse response, Exchange exchange, String operation) {
        if (!response.isSuccess()) {
            exchange.setException(new OpenstackOperationException(operation, response.getFault(), response.getCode()));
        }
    }
}

