/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openstack.keystone.producer;

import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.openstack.keystone.KeystoneEndpoint;
import org.apache.camel.component.openstack.keystone.producer.AbstractKeystoneProducer;
import org.apache.camel.util.StringHelper;
import org.openstack4j.api.Builders;
import org.openstack4j.api.OSClient;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.identity.v3.User;
import org.openstack4j.model.identity.v3.builder.UserBuilder;

public class UserProducer
extends AbstractKeystoneProducer {
    public UserProducer(KeystoneEndpoint endpoint, OSClient client) {
        super(endpoint, client);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = this.getOperation(exchange)) {
            case "create": {
                this.doCreate(exchange);
                break;
            }
            case "get": {
                this.doGet(exchange);
                break;
            }
            case "getAll": {
                this.doGetAll(exchange);
                break;
            }
            case "update": {
                this.doUpdate(exchange);
                break;
            }
            case "delete": {
                this.doDelete(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    private void doCreate(Exchange exchange) {
        User in = this.messageToUser(exchange.getIn());
        User out = this.osV3Client.identity().users().create(in);
        exchange.getIn().setBody(out);
    }

    private void doGet(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = msg.getHeader("ID", msg.getHeader("userId", String.class), String.class);
        StringHelper.notEmpty(id, "User ID");
        User result = this.osV3Client.identity().users().get(id);
        msg.setBody(result);
    }

    private void doGetAll(Exchange exchange) {
        List<? extends User> out = this.osV3Client.identity().users().list();
        exchange.getIn().setBody(out);
    }

    private void doUpdate(Exchange exchange) {
        Message msg = exchange.getIn();
        User in = this.messageToUser(msg);
        User out = this.osV3Client.identity().users().update(in);
        msg.setBody(out);
    }

    private void doDelete(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = msg.getHeader("ID", msg.getHeader("userId", String.class), String.class);
        StringHelper.notEmpty(id, "User ID");
        ActionResponse response = this.osV3Client.identity().users().delete(id);
        this.checkFailure(response, exchange, "Delete user with ID " + id);
    }

    private User messageToUser(Message message) {
        User project = message.getBody(User.class);
        if (project == null) {
            Map<String, Object> headers = message.getHeaders();
            UserBuilder builder = Builders.user();
            StringHelper.notEmpty(message.getHeader("name", String.class), "Name");
            builder.name(message.getHeader("name", String.class));
            if (headers.containsKey("domainId")) {
                builder.domainId(message.getHeader("domainId", String.class));
            }
            if (headers.containsKey("description")) {
                builder.description(message.getHeader("description", String.class));
            }
            if (headers.containsKey("password")) {
                builder.password(message.getHeader("password", String.class));
            }
            if (headers.containsKey("email")) {
                builder.email(message.getHeader("email", String.class));
            }
            project = (User)builder.build();
        }
        return project;
    }
}

