/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openstack.neutron.producer;

import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.openstack.common.AbstractOpenstackProducer;
import org.apache.camel.component.openstack.neutron.NeutronEndpoint;
import org.apache.camel.util.StringHelper;
import org.openstack4j.api.Builders;
import org.openstack4j.api.OSClient;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.Network;
import org.openstack4j.model.network.NetworkType;
import org.openstack4j.model.network.builder.NetworkBuilder;

public class NetworkProducer
extends AbstractOpenstackProducer {
    public NetworkProducer(NeutronEndpoint endpoint, OSClient client) {
        super(endpoint, client);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = this.getOperation(exchange)) {
            case "create": {
                this.doCreate(exchange);
                break;
            }
            case "get": {
                this.doGet(exchange);
                break;
            }
            case "getAll": {
                this.doGetAll(exchange);
                break;
            }
            case "delete": {
                this.doDelete(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    private void doCreate(Exchange exchange) {
        Network in = this.messageToNetwork(exchange.getIn());
        Network out = this.os.networking().network().create(in);
        exchange.getIn().setBody(out);
    }

    private void doGet(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = msg.getHeader("ID", msg.getHeader("networkId", String.class), String.class);
        StringHelper.notEmpty(id, "Network ID");
        Network out = this.os.networking().network().get(id);
        exchange.getIn().setBody(out);
    }

    private void doGetAll(Exchange exchange) {
        List<? extends Network> out = this.os.networking().network().list();
        exchange.getIn().setBody(out);
    }

    private void doDelete(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = msg.getHeader("ID", msg.getHeader("networkId", String.class), String.class);
        StringHelper.notEmpty(id, "Network ID");
        ActionResponse response = this.os.networking().network().delete(id);
        this.checkFailure(response, exchange, "Delete network" + id);
    }

    private Network messageToNetwork(Message message) {
        Network network = message.getBody(Network.class);
        if (network == null) {
            Map<String, Object> headers = message.getHeaders();
            NetworkBuilder builder = Builders.network();
            StringHelper.notEmpty(message.getHeader("name", String.class), "Name");
            builder.name(message.getHeader("name", String.class));
            if (headers.containsKey("adminStateUp")) {
                builder.adminStateUp(message.getHeader("adminStateUp", Boolean.class));
            }
            if (headers.containsKey("networkType")) {
                builder.networkType(message.getHeader("networkType", NetworkType.class));
            }
            if (headers.containsKey("isShared")) {
                builder.isShared(message.getHeader("isShared", Boolean.class));
            }
            if (headers.containsKey("isRouterExternal")) {
                builder.isRouterExternal(message.getHeader("isRouterExternal", Boolean.class));
            }
            if (headers.containsKey("tenantId")) {
                builder.tenantId(message.getHeader("tenantId", String.class));
            }
            if (headers.containsKey("physicalNetwork")) {
                builder.physicalNetwork(message.getHeader("physicalNetwork", String.class));
            }
            if (headers.containsKey("segmentId")) {
                builder.segmentId(message.getHeader("segmentId", String.class));
            }
            network = (Network)builder.build();
        }
        return network;
    }
}

