/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openstack.neutron.producer;

import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.openstack.common.AbstractOpenstackProducer;
import org.apache.camel.component.openstack.neutron.NeutronEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.openstack4j.api.Builders;
import org.openstack4j.api.OSClient;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.AttachInterfaceType;
import org.openstack4j.model.network.Router;
import org.openstack4j.model.network.RouterInterface;
import org.openstack4j.model.network.builder.RouterBuilder;

public class RouterProducer
extends AbstractOpenstackProducer {
    public RouterProducer(NeutronEndpoint endpoint, OSClient client) {
        super(endpoint, client);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = this.getOperation(exchange)) {
            case "create": {
                this.doCreate(exchange);
                break;
            }
            case "get": {
                this.doGet(exchange);
                break;
            }
            case "getAll": {
                this.doGetAll(exchange);
                break;
            }
            case "update": {
                this.doUpdate(exchange);
                break;
            }
            case "delete": {
                this.doDelete(exchange);
                break;
            }
            case "attachInterface": {
                this.doAttach(exchange);
                break;
            }
            case "detachInterface": {
                this.doDetach(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsuproutered operation " + operation);
            }
        }
    }

    private void doCreate(Exchange exchange) {
        Router in = this.messageToRouter(exchange.getIn());
        Router out = this.os.networking().router().create(in);
        exchange.getIn().setBody(out);
    }

    private void doGet(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = msg.getHeader("ID", msg.getHeader("routerId", String.class), String.class);
        StringHelper.notEmpty(id, "Router ID");
        Router result = this.os.networking().router().get(id);
        msg.setBody(result);
    }

    private void doGetAll(Exchange exchange) {
        List<? extends Router> out = this.os.networking().router().list();
        exchange.getIn().setBody(out);
    }

    private void doUpdate(Exchange exchange) {
        Message msg = exchange.getIn();
        Router router = this.messageToRouter(msg);
        Router updatedRouter = this.os.networking().router().update(router);
        msg.setBody(updatedRouter);
    }

    private void doDelete(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = msg.getHeader("ID", msg.getHeader("routerId", String.class), String.class);
        StringHelper.notEmpty(id, "Router ID");
        ActionResponse response = this.os.networking().router().delete(id);
        this.checkFailure(response, exchange, "Delete router with ID " + id);
    }

    private void doDetach(Exchange exchange) {
        Message msg = exchange.getIn();
        String routerId = msg.getHeader("routerId", String.class);
        String subnetId = msg.getHeader("subnetId", String.class);
        String portId = msg.getHeader("portId", String.class);
        StringHelper.notEmpty(routerId, "Router ID");
        RouterInterface iface = this.os.networking().router().detachInterface(routerId, subnetId, portId);
        msg.setBody(iface);
    }

    private void doAttach(Exchange exchange) {
        Message msg = exchange.getIn();
        String routerId = msg.getHeader("routerId", String.class);
        String subnetPortId = msg.getHeader("subnetId", msg.getHeader("portId"), String.class);
        AttachInterfaceType type = msg.getHeader("interfaceType", AttachInterfaceType.class);
        StringHelper.notEmpty(routerId, "Router ID");
        StringHelper.notEmpty(subnetPortId, "Subnet/Port ID");
        ObjectHelper.notNull(type, "AttachInterfaceType ");
        RouterInterface routerInterface = this.os.networking().router().attachInterface(routerId, type, subnetPortId);
        msg.setBody(routerInterface);
    }

    private Router messageToRouter(Message message) {
        Router router = message.getBody(Router.class);
        if (router == null) {
            Map<String, Object> headers = message.getHeaders();
            RouterBuilder builder = Builders.router();
            StringHelper.notEmpty(message.getHeader("name", String.class), "Name");
            builder.name(message.getHeader("name", String.class));
            if (headers.containsKey("tenantId")) {
                builder.tenantId(message.getHeader("tenantId", String.class));
            }
            router = (Router)builder.build();
        }
        return router;
    }
}

