/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openstack.nova.producer;

import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.openstack.common.AbstractOpenstackProducer;
import org.apache.camel.component.openstack.nova.NovaEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.openstack4j.api.Builders;
import org.openstack4j.api.OSClient;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.compute.Action;
import org.openstack4j.model.compute.Server;
import org.openstack4j.model.compute.ServerCreate;
import org.openstack4j.model.compute.builder.ServerCreateBuilder;

public class ServerProducer
extends AbstractOpenstackProducer {
    public ServerProducer(NovaEndpoint endpoint, OSClient client) {
        super(endpoint, client);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = this.getOperation(exchange)) {
            case "create": {
                this.doCreate(exchange);
                break;
            }
            case "createSnapshot": {
                this.doCreateSnapshot(exchange);
                break;
            }
            case "get": {
                this.doGet(exchange);
                break;
            }
            case "getAll": {
                this.doGetAll(exchange);
                break;
            }
            case "delete": {
                this.doDelete(exchange);
                break;
            }
            case "action": {
                this.doAction(exchange);
                break;
            }
            default: {
                if (exchange.getIn().getHeaders().containsKey("action")) {
                    this.doAction(exchange);
                    break;
                }
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    private void doCreate(Exchange exchange) {
        ServerCreate in = this.messageToServer(exchange.getIn());
        Server out = this.os.compute().servers().boot(in);
        exchange.getIn().setBody(out);
    }

    private void doCreateSnapshot(Exchange exchange) {
        Message msg = exchange.getIn();
        String serverId = msg.getHeader("ID", String.class);
        String name = msg.getHeader("name", String.class);
        StringHelper.notEmpty(serverId, "Server ID");
        StringHelper.notEmpty(name, "VolumeSnapshot name");
        String snapshotId = this.os.compute().servers().createSnapshot(serverId, name);
        msg.setBody(snapshotId);
    }

    private void doGet(Exchange exchange) {
        Message msg = exchange.getIn();
        String serverId = msg.getHeader("ID", String.class);
        StringHelper.notEmpty(serverId, "Server ID");
        Server result = this.os.compute().servers().get(serverId);
        msg.setBody(result);
    }

    private void doGetAll(Exchange exchange) {
        List<? extends Server> out = this.os.compute().servers().list();
        exchange.getIn().setBody(out);
    }

    private void doAction(Exchange exchange) {
        Message msg = exchange.getIn();
        Action action = msg.getHeader("action", Action.class);
        String serverId = msg.getHeader("ID", String.class);
        ObjectHelper.notNull(action, "Server action");
        StringHelper.notEmpty(serverId, "Server ID");
        ActionResponse response = this.os.compute().servers().action(serverId, action);
        this.checkFailure(response, exchange, "Performing action " + action.name());
    }

    private void doDelete(Exchange exchange) {
        Message msg = exchange.getIn();
        String serverId = msg.getHeader("ID", String.class);
        StringHelper.notEmpty(serverId, "Server ID");
        ActionResponse response = this.os.compute().servers().delete(serverId);
        this.checkFailure(response, exchange, "Delete server with ID " + serverId);
    }

    private ServerCreate messageToServer(Message message) {
        ServerCreate serverCreate = message.getBody(ServerCreate.class);
        if (serverCreate == null) {
            Map<String, Object> headers = message.getHeaders();
            ServerCreateBuilder builder = Builders.server();
            StringHelper.notEmpty(message.getHeader("name", String.class), "Name");
            builder.name(message.getHeader("name", String.class));
            if (headers.containsKey("ImageId")) {
                builder.image(message.getHeader("ImageId", String.class));
            }
            if (headers.containsKey("NetworkId")) {
                builder.networks(message.getHeader("NetworkId", List.class));
            }
            if (headers.containsKey("FlavorId")) {
                builder.flavor(message.getHeader("FlavorId", String.class));
            }
            if (headers.containsKey("KeypairName")) {
                builder.keypairName(message.getHeader("KeypairName", String.class));
            }
            if (headers.containsKey("AdminPassword")) {
                builder.addAdminPass(message.getHeader("AdminPassword", String.class));
            }
            serverCreate = (ServerCreate)builder.build();
        }
        return serverCreate;
    }
}

