/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.common;

import com.google.common.base.MoreObjects;
import java.io.Serializable;

public class ActionResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String message;
    private int code;

    private ActionResponse(int code) {
        this.code = code;
    }

    private ActionResponse(String message, int code) {
        this(code);
        this.message = message;
    }

    public static ActionResponse actionSuccess(int code) {
        return new ActionResponse(code);
    }

    public static ActionResponse actionSuccess() {
        return new ActionResponse(200);
    }

    public static ActionResponse actionFailed(String message, int code) {
        return new ActionResponse(message, code);
    }

    public int getCode() {
        return this.code;
    }

    public boolean isSuccess() {
        return this.message == null;
    }

    public String getFault() {
        return this.message;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("success", this.message == null).add("fault", this.message).add("code", this.code).toString();
    }
}

