/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.compute.actions;

import com.google.common.base.Preconditions;
import org.openstack4j.model.compute.actions.BaseActionOptions;

public final class BackupOptions
extends BaseActionOptions {
    private BackupOptions(String name) {
        this.add(Option.NAME, name);
    }

    public static BackupOptions create(String backupName) {
        Preconditions.checkNotNull(backupName);
        return new BackupOptions(backupName);
    }

    public BackupOptions daily(int rotation) {
        this.add(Option.BACKUP_TYPE, "daily");
        this.add(Option.ROTATION, rotation);
        return this;
    }

    public BackupOptions weekly(int rotation) {
        this.add(Option.BACKUP_TYPE, "weekly");
        this.add(Option.ROTATION, rotation);
        return this;
    }

    public String getName() {
        return (String)this.get(Option.NAME);
    }

    public String getBackupType() {
        return (String)this.get(Option.BACKUP_TYPE);
    }

    public Integer getRotation() {
        return (Integer)this.get(Option.ROTATION);
    }

    private static enum Option implements BaseActionOptions.OptionEnum
    {
        NAME("name"),
        BACKUP_TYPE("backup_type"),
        ROTATION("rotation");

        private final String param;

        private Option(String param) {
            this.param = param;
        }

        @Override
        public String getParam() {
            return this.param;
        }
    }
}

