/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.image;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum DiskFormat {
    RAW,
    VHD,
    VMDK,
    VDI,
    ISO,
    QCOW2,
    AKI,
    ARI,
    AMI,
    UNRECOGNIZED;


    @JsonCreator
    public static DiskFormat value(String df) {
        if (df == null || df.isEmpty()) {
            return UNRECOGNIZED;
        }
        try {
            return DiskFormat.valueOf(df.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return UNRECOGNIZED;
        }
    }

    @JsonValue
    public String value() {
        return this.name().toLowerCase();
    }
}

