/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.image.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ContainerFormat {
    BARE,
    OVF,
    AKI,
    ARI,
    AMI,
    OVA,
    DOCKER,
    UNRECOGNIZED;


    @JsonCreator
    public static ContainerFormat value(String cf) {
        if (cf == null || cf.isEmpty()) {
            return UNRECOGNIZED;
        }
        try {
            return ContainerFormat.valueOf(cf.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return UNRECOGNIZED;
        }
    }

    @JsonValue
    public String value() {
        return this.name().toLowerCase();
    }
}

