/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.storage.object.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;

public final class ContainerListOptions {
    private Map<String, String> queryParams = Maps.newHashMap();

    private ContainerListOptions() {
    }

    public static ContainerListOptions create() {
        return new ContainerListOptions();
    }

    public ContainerListOptions startsWith(String prefix) {
        return this.add("prefix", Preconditions.checkNotNull(prefix));
    }

    public ContainerListOptions limit(int limit) {
        Preconditions.checkState(limit >= 0, "limit must be >= 0");
        Preconditions.checkState(limit <= 10000, "limit must be <= 10000");
        this.add("limit", Integer.toString(limit));
        return this;
    }

    public ContainerListOptions marker(String marker) {
        this.add("marker", Preconditions.checkNotNull(marker, "marker"));
        return this;
    }

    public ContainerListOptions endMarker(String endMarker) {
        this.add("end_marker", Preconditions.checkNotNull(endMarker, "endMarker"));
        return this;
    }

    public ContainerListOptions delimiter(char delimiter) {
        return this.add("delimiter", Character.toString(delimiter));
    }

    public ContainerListOptions path(String path) {
        return this.add("path", Preconditions.checkNotNull(path));
    }

    private ContainerListOptions add(String param, String value) {
        this.queryParams.put(param, value);
        return this;
    }

    public Map<String, String> getOptions() {
        return this.queryParams;
    }
}

