/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.telemetry;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import org.openstack4j.openstack.internal.Parser;

public class EventCriteria {
    private List<NameOpValue> params = Lists.newArrayList();

    public static EventCriteria create() {
        return new EventCriteria();
    }

    public EventCriteria eventType(String eventType) {
        Preconditions.checkNotNull(eventType, "eventType must not be null");
        return this.add("event_type", Oper.EQUALS, eventType);
    }

    public EventCriteria messageId(String messageId) {
        Preconditions.checkNotNull(messageId, "messageId must not be null");
        return this.add("message_id", Oper.EQUALS, messageId);
    }

    public EventCriteria startTimestamp(Oper operator, Date value) {
        Preconditions.checkNotNull(value, "Date must not be null");
        return this.add("start_timestamp", operator, Parser.toISO8601DateFormat(value));
    }

    public EventCriteria endTimestamp(Oper operator, Date value) {
        Preconditions.checkNotNull(value, "Date must not be null");
        return this.add("end_timestamp", operator, Parser.toISO8601DateFormat(value));
    }

    public EventCriteria add(String field, Oper operator, Number value) {
        Preconditions.checkNotNull(value, "Value must not be null");
        return this.add(field, operator, value.toString());
    }

    public EventCriteria add(String field, Oper operator, String value) {
        Preconditions.checkNotNull(field, "Field must not be null");
        Preconditions.checkNotNull(operator, "Operator must not be null");
        Preconditions.checkNotNull(value, "Value must not be null");
        this.params.add(new NameOpValue(field, operator, (Comparable<?>)((Object)value)));
        return this;
    }

    public List<NameOpValue> getCriteriaParams() {
        return this.params;
    }

    public static class NameOpValue {
        private final String field;
        private final Oper operator;
        private String value;

        NameOpValue(String field, Oper operator, Comparable<?> value) {
            this.field = field;
            this.operator = operator;
            this.value = value instanceof Date ? Parser.toISO8601DateFormat((Date)Date.class.cast(value)) : String.valueOf(value);
        }

        public String getField() {
            return this.field;
        }

        public Oper getOperator() {
            return this.operator;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Oper {
        LT("lt"),
        GT("gt"),
        LTE("le"),
        GTE("ge"),
        EQUALS("eq");

        private final String queryValue;

        private Oper(String queryValue) {
            this.queryValue = queryValue;
        }

        public String getQueryValue() {
            return this.queryValue;
        }
    }
}

