/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.compute.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import org.openstack4j.model.compute.Keypair;
import org.openstack4j.openstack.common.ListResult;

@JsonRootName(value="keypair")
public class NovaKeypair
implements Keypair {
    private static final long serialVersionUID = 1L;
    private String name;
    @JsonProperty(value="public_key")
    private String publicKey;
    @JsonProperty(value="private_key")
    private String privateKey;
    private String fingerprint;
    @JsonProperty(value="user_id")
    private String userId;
    private Boolean deleted;
    @JsonProperty(value="created_at")
    private Date createdAt;
    @JsonProperty(value="updated_at")
    private Date updatedAt;
    @JsonProperty(value="deleted_at")
    private Date deletedAt;
    private Integer id;

    public static NovaKeypair create(String name, String publicKey) {
        NovaKeypair kp = new NovaKeypair();
        kp.name = name;
        kp.publicKey = publicKey;
        return kp;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPublicKey() {
        return this.publicKey;
    }

    @Override
    public String getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    public Date getDeletedAt() {
        return this.deletedAt;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("name", this.name).add("public_key", this.publicKey).add("private_key", this.privateKey).add("fingerprint", this.fingerprint).add("user_id", this.userId).add("deleted", this.deleted).add("created_at", this.createdAt).add("updated_at", this.updatedAt).add("deleted_at", this.deletedAt).add("id", this.id).toString();
    }

    public static class Keypairs
    extends ListResult<NovaKeypair> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="keypairs")
        private List<KeyPairWrapper> wrapped;
        private transient List<NovaKeypair> unwrapped;

        @Override
        protected List<NovaKeypair> value() {
            if (this.wrapped != null && this.unwrapped == null) {
                this.unwrapped = Lists.newArrayList();
                for (KeyPairWrapper kp : this.wrapped) {
                    this.unwrapped.add(kp.keypair);
                }
            }
            return this.unwrapped;
        }

        static final class KeyPairWrapper {
            @JsonProperty
            private NovaKeypair keypair;

            KeyPairWrapper() {
            }
        }
    }
}

