/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.gbp.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import java.util.List;
import org.openstack4j.model.gbp.PolicyAction;
import org.openstack4j.model.gbp.builder.PolicyActionCreateBuilder;
import org.openstack4j.openstack.common.ListResult;

@JsonRootName(value="policy_action")
public class GbpPolicyAction
implements PolicyAction {
    private static final long serialVersionUID = 1L;
    private String name;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    private String id;
    private String description;
    private Boolean shared;
    @JsonProperty(value="action_type")
    private PolicyAction.PolicyActionProtocol actionType;
    @JsonProperty(value="action_value")
    private String actionValue;

    public static PolicyActionCreateBuilder builder() {
        return new PolicyActionConcreteBuilder();
    }

    @Override
    public PolicyActionCreateBuilder toBuilder() {
        return new PolicyActionConcreteBuilder(this);
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isShared() {
        return this.shared == null ? false : this.shared;
    }

    @Override
    public PolicyAction.PolicyActionProtocol getActionType() {
        return this.actionType;
    }

    @Override
    public String getActionValue() {
        return this.actionValue;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("id", this.id).add("name", this.name).add("desription", this.description).add("tenantId", this.tenantId).add("actionType", (Object)this.actionType).add("actionValue", this.actionValue).add("shared", this.shared).toString();
    }

    public static class PolicyActionConcreteBuilder
    implements PolicyActionCreateBuilder {
        private GbpPolicyAction policyAction;

        public PolicyActionConcreteBuilder(GbpPolicyAction gbpPolicyAction) {
            this.policyAction = gbpPolicyAction;
        }

        public PolicyActionConcreteBuilder() {
            this(new GbpPolicyAction());
        }

        @Override
        public PolicyAction build() {
            return this.policyAction;
        }

        @Override
        public PolicyActionCreateBuilder from(PolicyAction in) {
            this.policyAction = (GbpPolicyAction)in;
            return this;
        }

        @Override
        public PolicyActionCreateBuilder name(String name) {
            this.policyAction.name = name;
            return this;
        }

        @Override
        public PolicyActionCreateBuilder description(String description) {
            this.policyAction.description = description;
            return this;
        }

        @Override
        public PolicyActionCreateBuilder actionType(PolicyAction.PolicyActionProtocol actionType) {
            this.policyAction.actionType = actionType;
            return this;
        }

        @Override
        public PolicyActionCreateBuilder shared(boolean shared) {
            this.policyAction.shared = shared;
            return this;
        }
    }

    public static class PolicyActions
    extends ListResult<GbpPolicyAction> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="policy_actions")
        private List<GbpPolicyAction> policyActions;

        @Override
        protected List<GbpPolicyAction> value() {
            return this.policyActions;
        }
    }
}

