/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.heat.utils;

import com.fasterxml.jackson.core.JsonParseException;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstack4j.openstack.heat.utils.TemplateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class Template {
    private static final Logger LOG = LoggerFactory.getLogger(Template.class);
    private static final String GET_FILE = "get_file";
    private String tplContent;
    private Map<String, String> files = new HashMap<String, String>();
    private URL baseUrl;

    public Template(URL templateRes) throws JsonParseException, IOException {
        this.setTplContent(Resources.toString(templateRes, Charsets.UTF_8));
        this.baseUrl = TemplateUtils.baseUrl(templateRes.toString());
        this.getFileContents();
    }

    public Template(String templateLoc) throws JsonParseException, MalformedURLException, UnsupportedEncodingException, IOException, URISyntaxException {
        this(TemplateUtils.normaliseFilePathToUrl(templateLoc));
    }

    private void getFileContents() {
        Yaml yaml = new Yaml();
        Map content = (Map)yaml.load(this.getTplContent());
        try {
            this.resolveTemplateGetFiles(content);
            this.resolveTemplateType(content);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private void resolveTemplateType(Map<?, ?> map) throws MalformedURLException, IOException {
        for (Object key : map.keySet()) {
            String valueInString;
            if (!(key instanceof String)) continue;
            String skey = (String)key;
            Object value = map.get(skey);
            if (value instanceof String && this.isTemplate(skey, valueInString = (String)value)) {
                try {
                    String templateName = valueInString;
                    URL fullTemplateName = TemplateUtils.normaliseFilePathToUrl(this.baseUrl.toString(), templateName);
                    if (!this.files.containsKey(templateName)) {
                        Template tpl = new Template(fullTemplateName);
                        this.files.put(templateName, tpl.getTplContent());
                        this.files.putAll(tpl.getFiles());
                    }
                }
                catch (URISyntaxException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
            if (value instanceof Map) {
                this.resolveTemplateType((Map)value);
                continue;
            }
            if (!(value instanceof List)) continue;
            for (Object item : (List)value) {
                if (!(item instanceof Map)) continue;
                this.resolveTemplateType((Map)item);
            }
        }
    }

    private void resolveTemplateGetFiles(Map<?, ?> map) throws IOException {
        for (Object key : map.keySet()) {
            if (!(key instanceof String)) continue;
            String skey = (String)key;
            Object value = map.get(skey);
            if (this.isGetFile(skey)) {
                this.addToFiles((String)value);
                continue;
            }
            Object subMap = map.get(skey);
            if (subMap instanceof Map) {
                this.resolveTemplateGetFiles((Map)subMap);
                continue;
            }
            if (!(subMap instanceof List)) continue;
            for (Object item : (List)subMap) {
                if (!(item instanceof Map)) continue;
                this.resolveTemplateGetFiles((Map)item);
            }
        }
    }

    private void addToFiles(String filename) throws IOException {
        if (!this.files.containsKey(filename)) {
            if (filename.startsWith("/")) {
                this.files.put(filename, TemplateUtils.readToString(filename));
            } else {
                this.files.put(filename, TemplateUtils.readToString(this.baseUrl + filename));
            }
        }
    }

    private boolean isGetFile(String tag) {
        return tag.equals(GET_FILE);
    }

    private boolean isTemplate(String key, String value) {
        if (!key.equals("type")) {
            return false;
        }
        return value.endsWith(".yaml") || value.endsWith(".template");
    }

    public String getTplContent() {
        return this.tplContent;
    }

    public void setTplContent(String tplContent) {
        this.tplContent = tplContent;
    }

    public Map<String, String> getFiles() {
        return this.files;
    }

    public void setFiles(Map<String, String> files) {
        this.files = files;
    }
}

