/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v2.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.identity.v2.TenantService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.identity.v2.Tenant;
import org.openstack4j.model.identity.v2.TenantUser;
import org.openstack4j.openstack.identity.v2.domain.KeystoneTenant;
import org.openstack4j.openstack.identity.v2.domain.KeystoneTenantUser;
import org.openstack4j.openstack.internal.BaseOpenStackService;

public class TenantServiceImpl
extends BaseOpenStackService
implements TenantService {
    @Override
    public List<? extends Tenant> list() {
        return this.get(KeystoneTenant.Tenants.class, "/tenants").execute().getList();
    }

    @Override
    public Tenant get(String tenantId) {
        Preconditions.checkNotNull(tenantId);
        return this.get(KeystoneTenant.class, "/tenants", "/", tenantId).execute();
    }

    @Override
    public Tenant getByName(String tenantName) {
        Preconditions.checkNotNull(tenantName);
        return this.get(KeystoneTenant.BackwardsCompatTenants.class, "/tenants").param("name", tenantName).execute().getOneOrNull();
    }

    @Override
    public Tenant create(Tenant tenant) {
        Preconditions.checkNotNull(tenant);
        return this.post(KeystoneTenant.class, "/tenants").entity(tenant).execute();
    }

    @Override
    public ActionResponse delete(String tenantId) {
        Preconditions.checkNotNull(tenantId);
        return this.deleteWithResponse("/tenants", "/", tenantId).execute();
    }

    @Override
    public Tenant update(Tenant tenant) {
        Preconditions.checkNotNull(tenant);
        return this.post(KeystoneTenant.class, this.uri("/tenants/%s", tenant.getId())).entity(tenant).execute();
    }

    @Override
    public List<? extends TenantUser> listUsers(String tenantId) {
        Preconditions.checkNotNull(tenantId);
        return this.get(KeystoneTenantUser.TenantUsers.class, this.uri("/tenants/%s/users", tenantId)).execute().getList();
    }
}

