/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v3.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.openstack4j.model.identity.v3.Domain;
import org.openstack4j.model.identity.v3.builder.DomainBuilder;
import org.openstack4j.openstack.common.ListResult;

@JsonRootName(value="domain")
@JsonIgnoreProperties(ignoreUnknown=true)
public class KeystoneDomain
implements Domain {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private String id;
    @JsonProperty
    private String name;
    private String description;
    private Map<String, String> options = Maps.newHashMap();
    private Map<String, String> links;
    private boolean enabled;

    public static DomainBuilder builder() {
        return new DomainConcreteBuilder();
    }

    @Override
    public DomainBuilder toBuilder() {
        return new DomainConcreteBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, String> getOptions() {
        return this.options;
    }

    @Override
    public Map<String, String> getLinks() {
        return this.links;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("id", this.id).add("description", this.description).add("name", this.name).add("links", this.links).add("enabled", this.enabled).toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.description, this.enabled, this.name, this.links);
    }

    public static class Domains
    extends ListResult<KeystoneDomain> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="domains")
        protected List<KeystoneDomain> list;

        @Override
        protected List<KeystoneDomain> value() {
            return this.list;
        }
    }

    public static class DomainConcreteBuilder
    implements DomainBuilder {
        KeystoneDomain model;

        public DomainConcreteBuilder() {
            this(new KeystoneDomain());
        }

        DomainConcreteBuilder(KeystoneDomain model) {
            this.model = model;
        }

        @Override
        public Domain build() {
            return this.model;
        }

        @Override
        public DomainBuilder from(Domain in) {
            if (in != null) {
                this.model = (KeystoneDomain)in;
            }
            return this;
        }

        @Override
        public DomainBuilder id(String id) {
            this.model.id = id;
            return this;
        }

        @Override
        public DomainBuilder description(String description) {
            this.model.description = description;
            return this;
        }

        @Override
        public DomainBuilder name(String name) {
            this.model.name = name;
            return this;
        }

        @Override
        public DomainBuilder options(Map<String, String> options) {
            this.model.options = options;
            return this;
        }

        @Override
        public DomainBuilder links(Map<String, String> links) {
            this.model.links = links;
            return this;
        }

        @Override
        public DomainBuilder enabled(boolean enabled) {
            this.model.enabled = enabled;
            return this;
        }
    }
}

