/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v3.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Map;
import org.openstack4j.model.identity.v3.Endpoint;
import org.openstack4j.model.identity.v3.Service;
import org.openstack4j.model.identity.v3.builder.ServiceBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.identity.v3.domain.KeystoneEndpoint;

@JsonRootName(value="service")
@JsonIgnoreProperties(ignoreUnknown=true)
public class KeystoneService
implements Service,
Comparable<Service> {
    private static final long serialVersionUID = 1L;
    private Integer version;
    @JsonProperty
    private String id;
    @JsonProperty
    private String name;
    @JsonProperty
    private String type;
    @JsonProperty
    private List<KeystoneEndpoint> endpoints;
    private String description;
    private Boolean enabled = true;
    private Map<String, String> links;

    public static ServiceBuilder builder() {
        return new ServiceConcreteBuilder();
    }

    @Override
    public ServiceBuilder toBuilder() {
        return new ServiceConcreteBuilder(this);
    }

    @Override
    public Integer getVersion() {
        return this.version;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public List<? extends Endpoint> getEndpoints() {
        return this.endpoints;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled != null && this.enabled != false;
    }

    @Override
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public Map<String, String> getLinks() {
        return this.links;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("id", this.id).add("name", this.name).add("description", this.description).add("type", this.type).add("version", this.version).add("enabled", this.enabled).add("links", this.links).toString();
    }

    @Override
    public int compareTo(Service s) {
        return this.getVersion().compareTo(s.getVersion());
    }

    public static class ServiceConcreteBuilder
    implements ServiceBuilder {
        private KeystoneService model;

        ServiceConcreteBuilder() {
            this(new KeystoneService());
        }

        ServiceConcreteBuilder(KeystoneService model) {
            this.model = model;
        }

        @Override
        public Service build() {
            return this.model;
        }

        @Override
        public ServiceBuilder from(Service in) {
            this.model = (KeystoneService)in;
            return this;
        }

        @Override
        public ServiceBuilder version(Integer version) {
            this.model.version = version;
            return this;
        }

        @Override
        public ServiceBuilder id(String id) {
            this.model.id = id;
            return this;
        }

        @Override
        public ServiceBuilder description(String description) {
            this.model.description = description;
            return this;
        }

        @Override
        public ServiceBuilder type(String type) {
            this.model.type = type;
            return this;
        }

        @Override
        public ServiceBuilder name(String name) {
            this.model.name = name;
            return this;
        }

        @Override
        public ServiceBuilder enabled(boolean enabled) {
            this.model.enabled = enabled;
            return this;
        }

        @Override
        public ServiceBuilder links(Map<String, String> links) {
            this.model.links = links;
            return this;
        }
    }

    public static class Catalog
    extends ListResult<KeystoneService> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="catalog")
        private List<KeystoneService> list;

        @Override
        protected List<KeystoneService> value() {
            return this.list;
        }
    }

    public static class Services
    extends ListResult<KeystoneService> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="services")
        private List<KeystoneService> list;

        @Override
        protected List<KeystoneService> value() {
            return this.list;
        }
    }
}

