/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.identity.v3.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.identity.v3.CredentialService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.identity.v3.Credential;
import org.openstack4j.openstack.identity.v3.domain.KeystoneCredential;
import org.openstack4j.openstack.identity.v3.internal.BaseIdentityServices;

public class CredentialServiceImpl
extends BaseIdentityServices
implements CredentialService {
    @Override
    public Credential create(Credential credential) {
        Preconditions.checkNotNull(credential);
        return this.post(KeystoneCredential.class, this.uri("/credentials", new Object[0])).entity(credential).execute();
    }

    @Override
    public Credential create(String blob, String type, String projectId, String userId) {
        Preconditions.checkNotNull(blob);
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull(projectId);
        Preconditions.checkNotNull(userId);
        return this.create((Credential)KeystoneCredential.builder().blob(blob).type(type).projectId(projectId).userId(userId).build());
    }

    @Override
    public Credential get(String credentialId) {
        Preconditions.checkNotNull(credentialId);
        return this.get(KeystoneCredential.class, "/credentials", "/", credentialId).execute();
    }

    @Override
    public Credential update(Credential credential) {
        Preconditions.checkNotNull(credential);
        return this.patch(KeystoneCredential.class, "/credentials", "/", credential.getId()).entity(credential).execute();
    }

    @Override
    public ActionResponse delete(String credentialId) {
        Preconditions.checkNotNull(credentialId);
        return this.deleteWithResponse("/credentials", "/", credentialId).execute();
    }

    @Override
    public List<? extends Credential> list() {
        return this.get(KeystoneCredential.Credentials.class, this.uri("/credentials", new Object[0])).execute().getList();
    }
}

