/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.image.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import java.util.Date;
import java.util.List;
import org.openstack4j.model.image.CachedImage;
import org.openstack4j.openstack.common.CustomEpochToDateDeserializer;
import org.openstack4j.openstack.common.ListResult;

public class CachedGlanceImage
implements CachedImage {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="image_id")
    private String imageId;
    private Integer hits;
    @JsonProperty(value="last_accessed")
    @JsonDeserialize(using=CustomEpochToDateDeserializer.class)
    private Date lastAccessed;
    @JsonDeserialize(using=CustomEpochToDateDeserializer.class)
    @JsonProperty(value="last_modified")
    private Date lastModified;
    private Long size;

    @Override
    public String getImageId() {
        return this.imageId;
    }

    @Override
    public Date getLastAccessed() {
        return this.lastAccessed;
    }

    @Override
    public Date getLastModified() {
        return this.lastModified;
    }

    @Override
    public Integer getHits() {
        return this.hits;
    }

    @Override
    public Long getSize() {
        return this.size;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("id", this.imageId).add("size", this.size).add("hits", this.hits).add("lastAccessed", this.lastAccessed).add("lastModified", this.lastModified).addValue("\n").toString();
    }

    public static class CachedImages
    extends ListResult<CachedGlanceImage> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="cached_images")
        private List<CachedGlanceImage> cachedImages;

        @Override
        protected List<CachedGlanceImage> value() {
            return this.cachedImages;
        }
    }
}

