/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.image.v2.domain;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openstack4j.model.image.v2.ImageUpdate;
import org.openstack4j.model.image.v2.builder.ImageUpdateBuilder;
import org.openstack4j.openstack.image.v2.domain.PatchOperation;

public class GlanceImageUpdate
implements ImageUpdate {
    List<PatchOperation> ops = new ArrayList<PatchOperation>();

    public GlanceImageUpdate() {
    }

    public GlanceImageUpdate(JsonNode value) {
        if (value.isArray()) {
            Iterator<JsonNode> iterator = value.iterator();
            while (iterator.hasNext()) {
                JsonNode next = iterator.next();
                iterator.remove();
                PatchOperation p = new PatchOperation(PatchOperation.OperationType.value(next.get("op").textValue()), next.get("path").textValue(), next.get("value"));
                this.ops.add(p);
            }
        }
    }

    public GlanceImageUpdate(List<PatchOperation> ops) {
        this.ops = ops;
    }

    public static ImageUpdateBuilder builder() {
        return new ImageUpdateConcreteBuilder();
    }

    @Override
    @JsonValue
    public List<PatchOperation> getOps() {
        return this.ops;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("ops", this.ops).toString();
    }

    @Override
    public ImageUpdateBuilder toBuilder() {
        return new ImageUpdateConcreteBuilder(this);
    }

    public static class ImageUpdateConcreteBuilder
    implements ImageUpdateBuilder {
        private GlanceImageUpdate m;

        public ImageUpdateConcreteBuilder() {
            this(new GlanceImageUpdate());
        }

        public ImageUpdateConcreteBuilder(GlanceImageUpdate m) {
            this.m = m;
        }

        @Override
        public ImageUpdateBuilder ops(List<PatchOperation> ops) {
            this.m.ops = ops;
            return this;
        }

        @Override
        public ImageUpdateBuilder ops(PatchOperation op) {
            if (this.m.ops == null) {
                this.m.ops = new ArrayList<PatchOperation>();
            }
            this.m.ops.add(op);
            return this;
        }

        @Override
        public ImageUpdate build() {
            return this.m;
        }

        @Override
        public ImageUpdateBuilder from(ImageUpdate in) {
            this.m = (GlanceImageUpdate)in;
            return this;
        }
    }
}

