/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.murano.v1.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openstack4j.api.murano.v1.MuranoActionService;
import org.openstack4j.model.murano.v1.domain.ActionInfo;
import org.openstack4j.model.murano.v1.domain.ActionResult;
import org.openstack4j.model.murano.v1.domain.Application;
import org.openstack4j.model.murano.v1.domain.Environment;
import org.openstack4j.openstack.common.MapEntity;
import org.openstack4j.openstack.murano.v1.domain.MuranoActionResult;
import org.openstack4j.openstack.murano.v1.domain.MuranoEnvironment;
import org.openstack4j.openstack.murano.v1.internal.BaseMuranoServices;

public class MuranoActionServiceImpl
extends BaseMuranoServices
implements MuranoActionService {
    @Override
    public List<? extends ActionInfo> list(String envId, String serviceId) {
        Preconditions.checkNotNull(envId);
        Preconditions.checkNotNull(serviceId);
        Environment env = this.get(MuranoEnvironment.class, this.uri("/environments/%s", envId)).execute();
        for (Application application : env.getServices()) {
            if (!application.getService().getId().equals(serviceId)) continue;
            return application.getService().getActions();
        }
        return null;
    }

    @Override
    public List<? extends ActionInfo> list(String envId) {
        Preconditions.checkNotNull(envId);
        return this.getAllActions(envId);
    }

    @Override
    public ActionInfo get(String envId, String actionId) {
        Preconditions.checkNotNull(envId);
        Preconditions.checkNotNull(actionId);
        for (ActionInfo actionInfo : this.getAllActions(envId)) {
            if (!actionInfo.getId().equals(actionId)) continue;
            return actionInfo;
        }
        return null;
    }

    @Override
    public ActionInfo find(String envId, String actionName) {
        Preconditions.checkNotNull(envId);
        Preconditions.checkNotNull(actionName);
        for (ActionInfo actionInfo : this.getAllActions(envId)) {
            if (!actionInfo.getName().equals(actionName)) continue;
            return actionInfo;
        }
        return null;
    }

    @Override
    public List<? extends ActionInfo> findAll(String envId, String actionName) {
        Preconditions.checkNotNull(envId);
        Preconditions.checkNotNull(actionName);
        ArrayList<ActionInfo> actions = new ArrayList<ActionInfo>();
        for (ActionInfo actionInfo : this.getAllActions(envId)) {
            if (!actionInfo.getName().equals(actionName)) continue;
            actions.add(actionInfo);
        }
        if (actions.size() == 0) {
            return null;
        }
        return actions;
    }

    @Override
    public String cast(String envId, String actionId, String jsonString) {
        ObjectMapper mapper = new ObjectMapper();
        Map arguments = null;
        try {
            arguments = mapper.readValue(jsonString, Map.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.cast(envId, actionId, arguments);
    }

    @Override
    public String cast(String envId, String actionId, Map<String, Object> arguments) {
        MapEntity entity = new MapEntity();
        entity.putAll(arguments);
        MapEntity result = this.post(MapEntity.class, this.uri("/environments/%s/actions/%s", envId, actionId)).entity(entity).execute();
        return (String)result.get("task_id");
    }

    @Override
    public String cast(String envId, String actionId) {
        return this.cast(envId, actionId, "{}");
    }

    @Override
    public ActionResult getResult(String envId, String taskId) {
        return this.get(MuranoActionResult.class, this.uri("/environments/%s/actions/%s", envId, taskId)).execute();
    }

    @Override
    public ActionResult run(String envId, String actionId) {
        return this.run(envId, actionId, "{}");
    }

    @Override
    public ActionResult run(String envId, String actionId, String jsonString) {
        ObjectMapper mapper = new ObjectMapper();
        Map arguments = null;
        try {
            arguments = mapper.readValue(jsonString, Map.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.run(envId, actionId, arguments);
    }

    @Override
    public ActionResult run(String envId, String actionId, Map<String, Object> arguments) {
        String taskId = this.cast(envId, actionId, arguments);
        ActionResult result = new MuranoActionResult();
        while (result.isException() == null) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            result = this.getResult(envId, taskId);
        }
        return result;
    }

    protected List<? extends ActionInfo> getAllActions(String envId) {
        Environment env = this.get(MuranoEnvironment.class, this.uri("/environments/%s", envId)).execute();
        ArrayList<? extends ActionInfo> actions = new ArrayList<ActionInfo>();
        for (Application application : env.getServices()) {
            if (application.getService().getActions() == null) continue;
            actions.addAll(application.getService().getActions());
        }
        if (actions.size() == 0) {
            return null;
        }
        return actions;
    }
}

