/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import org.openstack4j.model.common.builder.ResourceBuilder;
import org.openstack4j.model.network.State;
import org.openstack4j.model.network.Trunk;
import org.openstack4j.model.network.builder.TrunkBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.networking.domain.NeutronTrunk;
import org.openstack4j.openstack.networking.domain.NeutronTrunkSubport;

public abstract class AbstractNeutronTrunk
implements Trunk {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="admin_state_up")
    protected boolean adminStateUp = true;
    @JsonProperty(value="description")
    protected String description;
    @JsonProperty(value="id")
    protected String id;
    @JsonProperty(value="name")
    protected String name;
    @JsonProperty(value="port_id")
    protected String parentPortId;
    @JsonProperty(value="revision_number")
    protected int revisionNumber;
    @JsonProperty(value="status")
    protected State state;
    @JsonProperty(value="sub_ports")
    protected List<NeutronTrunkSubport> trunkSubports;
    @JsonProperty(value="tenant_id")
    protected String tenantId;

    public static TrunkBuilder builder() {
        return new TrunkConcreteBuilder();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NeutronTrunk) {
            NeutronTrunk that = (NeutronTrunk)obj;
            if (Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.adminStateUp, that.adminStateUp) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.parentPortId, that.parentPortId) && Objects.equals(this.revisionNumber, that.revisionNumber) && Objects.equals((Object)this.state, (Object)that.state) && Objects.equals(this.trunkSubports, that.trunkSubports) && Objects.equals(this.description, that.description)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.parentPortId, this.revisionNumber, this.state, this.tenantId, this.trunkSubports, this.description});
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getParentPort() {
        return this.parentPortId;
    }

    public int getRevisionNumber() {
        return this.revisionNumber;
    }

    @Override
    public State getState() {
        return this.state;
    }

    public List<NeutronTrunkSubport> getTrunkSubports() {
        return this.trunkSubports;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public boolean isAdminStateUp() {
        return this.adminStateUp;
    }

    public void setPortId(String parentPortId) {
        this.parentPortId = parentPortId;
    }

    @Override
    public TrunkBuilder toBuilder() {
        return new TrunkConcreteBuilder(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("id", this.id).add("name", this.name).add("adminStateUp", this.adminStateUp).add("parentPortId", this.parentPortId).add("revisionNumber", this.revisionNumber).add("state", (Object)this.state).add("tenantId", this.tenantId).add("trunkSubports", this.trunkSubports).add("description", this.description).toString();
    }

    public static class Trunks
    extends ListResult<NeutronTrunk> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="trunks")
        private List<NeutronTrunk> trunks;

        @Override
        protected List<NeutronTrunk> value() {
            return this.trunks;
        }
    }

    public static class TrunkConcreteBuilder
    extends ResourceBuilder<Trunk, TrunkConcreteBuilder>
    implements TrunkBuilder {
        NeutronTrunk reference;

        TrunkConcreteBuilder() {
            this(new NeutronTrunk());
        }

        TrunkConcreteBuilder(Trunk trunk) {
            this.reference = (NeutronTrunk)trunk;
        }

        @Override
        public TrunkBuilder adminState(boolean adminStateUp) {
            this.reference.adminStateUp = adminStateUp;
            return this;
        }

        @Override
        public Trunk build() {
            return this.reference;
        }

        @Override
        public TrunkBuilder description(String description) {
            this.reference.description = description;
            return this;
        }

        @Override
        public TrunkBuilder from(Trunk in) {
            this.reference = (NeutronTrunk)in;
            return this;
        }

        @Override
        public TrunkBuilder parentPort(String parentPortId) {
            this.reference.parentPortId = parentPortId;
            return this;
        }

        @Override
        protected Trunk reference() {
            return this.reference;
        }

        @Override
        public TrunkBuilder trunkSubports(List<NeutronTrunkSubport> trunkSubports) {
            this.reference.trunkSubports = trunkSubports;
            return this;
        }

        @Override
        public TrunkBuilder trunkId(String trunkId) {
            this.reference.id = trunkId;
            return this;
        }
    }
}

