/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstack4j.model.ModelEntity;
import org.openstack4j.model.network.Port;
import org.openstack4j.openstack.common.ListEntity;
import org.openstack4j.openstack.networking.domain.NeutronAllowedAddressPair;
import org.openstack4j.openstack.networking.domain.NeutronIP;

@JsonRootName(value="port")
@JsonIgnoreProperties(ignoreUnknown=true)
public class NeutronPortCreate
implements ModelEntity {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private String name;
    @JsonProperty(value="admin_state_up")
    private boolean adminStateUp;
    @JsonProperty(value="fixed_ips")
    private Set<NeutronIP> fixedIps;
    @JsonProperty(value="mac_address")
    private String macAddress;
    @JsonProperty(value="allowed_address_pairs")
    private Set<NeutronAllowedAddressPair> allowedAddressPairs;
    @JsonProperty(value="network_id")
    private String networkId;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    @JsonProperty(value="device_id")
    private String deviceId;
    @JsonProperty(value="device_owner")
    private String deviceOwner;
    @JsonProperty(value="security_groups")
    private List<String> securityGroups;
    @JsonProperty(value="port_security_enabled")
    private Boolean portSecurityEnabled;
    @JsonProperty(value="binding:host_id")
    private String hostId;
    @JsonProperty(value="binding:vif_type")
    private String vifType;
    @JsonProperty(value="binding:vif_details")
    private Map<String, Object> vifDetails;
    @JsonProperty(value="binding:vnic_type")
    private String vNicType;
    @JsonProperty(value="binding:profile")
    private Map<String, Object> profile;

    public static NeutronPortCreate fromPort(Port port) {
        NeutronPortCreate c = new NeutronPortCreate();
        c.name = port.getName();
        c.networkId = port.getNetworkId();
        c.adminStateUp = port.isAdminStateUp();
        c.macAddress = port.getMacAddress();
        c.tenantId = port.getTenantId();
        c.deviceId = port.getDeviceId();
        c.deviceOwner = port.getDeviceOwner();
        c.securityGroups = port.getSecurityGroups();
        c.fixedIps = port.getFixedIps();
        c.allowedAddressPairs = port.getAllowedAddressPairs();
        c.portSecurityEnabled = port.isPortSecurityEnabled();
        c.hostId = port.getHostId();
        c.vifType = port.getVifType();
        c.vifDetails = port.getVifDetails();
        c.vNicType = port.getvNicType();
        c.profile = port.getProfile();
        return c;
    }

    public static class NeutronPortsCreate
    implements ModelEntity {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="ports")
        private ListEntity<NeutronPortCreate> ports = new ListEntity();

        public static NeutronPortsCreate fromPorts(List<? extends Port> ports) {
            NeutronPortsCreate c = new NeutronPortsCreate();
            for (Port port : ports) {
                c.ports.add(NeutronPortCreate.fromPort(port));
            }
            return c;
        }
    }
}

