/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import org.openstack4j.model.network.SecurityGroup;
import org.openstack4j.model.network.SecurityGroupRule;
import org.openstack4j.model.network.builder.NetSecurityGroupBuilder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.networking.domain.NeutronSecurityGroupRule;

@JsonRootName(value="security_group")
public class NeutronSecurityGroup
implements SecurityGroup {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="security_group_rules")
    private List<NeutronSecurityGroupRule> rules;

    public static NetSecurityGroupBuilder builder() {
        return new SecurityGroupConcreteBuilder();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<? extends SecurityGroupRule> getRules() {
        return this.rules;
    }

    @Override
    public NetSecurityGroupBuilder toBuilder() {
        return new SecurityGroupConcreteBuilder(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("id", this.id).add("tenantId", this.tenantId).add("name", this.name).add("description", this.description).add("security_group_rules", this.rules).addValue("\n").toString();
    }

    public int hashCode() {
        return Objects.hash(this.id, this.tenantId, this.name, this.description, this.rules);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NeutronSecurityGroup) {
            NeutronSecurityGroup that = (NeutronSecurityGroup)obj;
            if (Objects.equals(this.id, that.id) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.rules, that.rules)) {
                return true;
            }
        }
        return false;
    }

    public static class SecurityGroupConcreteBuilder
    implements NetSecurityGroupBuilder {
        NeutronSecurityGroup g;

        public SecurityGroupConcreteBuilder() {
            this.g = new NeutronSecurityGroup();
        }

        public SecurityGroupConcreteBuilder(SecurityGroup in) {
            this.g = (NeutronSecurityGroup)in;
        }

        @Override
        public SecurityGroup build() {
            return this.g;
        }

        @Override
        public NetSecurityGroupBuilder from(SecurityGroup in) {
            this.g = (NeutronSecurityGroup)in;
            return this;
        }

        @Override
        public NetSecurityGroupBuilder name(String name) {
            this.g.name = name;
            return this;
        }

        @Override
        public NetSecurityGroupBuilder description(String description) {
            this.g.description = description;
            return this;
        }

        @Override
        public NetSecurityGroupBuilder id(String id) {
            this.g.id = id;
            return this;
        }

        @Override
        public NetSecurityGroupBuilder tenantId(String tenantId) {
            this.g.tenantId = tenantId;
            return this;
        }
    }

    public static class SecurityGroups
    extends ListResult<NeutronSecurityGroup> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="security_groups")
        private List<NeutronSecurityGroup> rules;

        @Override
        protected List<NeutronSecurityGroup> value() {
            return this.rules;
        }
    }
}

