/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain.ext;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import java.util.List;
import org.openstack4j.model.network.ext.HealthMonitorType;
import org.openstack4j.model.network.ext.HealthMonitorV2;
import org.openstack4j.model.network.ext.builder.HealthMonitorV2Builder;
import org.openstack4j.openstack.common.ListResult;
import org.openstack4j.openstack.networking.domain.ext.ListItem;

@JsonRootName(value="healthmonitor")
@JsonIgnoreProperties(ignoreUnknown=true)
public class NeutronHealthMonitorV2
implements HealthMonitorV2 {
    private String id;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    private HealthMonitorType type;
    private Integer delay;
    private Integer timeout;
    @JsonProperty(value="max_retries")
    private Integer maxRetries;
    @JsonProperty(value="http_method")
    private String httpMethod;
    @JsonProperty(value="url_path")
    private String urlPath;
    @JsonProperty(value="expected_codes")
    private String expectedCodes;
    @JsonProperty(value="admin_state_up")
    private boolean adminStateUp = true;
    private List<ListItem> pools;
    @JsonProperty(value="pool_id")
    private String poolId;

    public static HealthMonitorV2Builder builder() {
        return new HealthMonitorV2Concretebuilder();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public HealthMonitorType getType() {
        return this.type;
    }

    @Override
    public Integer getDelay() {
        return this.delay;
    }

    @Override
    public Integer getTimeout() {
        return this.timeout;
    }

    @Override
    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    @Override
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public String getUrlPath() {
        return this.urlPath;
    }

    @Override
    public String getExpectedCodes() {
        return this.expectedCodes;
    }

    @Override
    public boolean isAdminStateUp() {
        return this.adminStateUp;
    }

    @Override
    public List<ListItem> getPools() {
        return this.pools;
    }

    @Override
    public HealthMonitorV2Builder toBuilder() {
        return new HealthMonitorV2Concretebuilder(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("tenantId", this.tenantId).add("type", (Object)this.type).add("delay", this.delay).add("timeout", this.timeout).add("maxRetries", this.maxRetries).add("httpMethod", this.httpMethod).add("urlPath", this.urlPath).add("expectedCodes", this.expectedCodes).add("adminStateUp", this.adminStateUp).add("pools", this.pools).add("poolId", this.poolId).toString();
    }

    public static class HealthMonitorV2Concretebuilder
    implements HealthMonitorV2Builder {
        NeutronHealthMonitorV2 m;

        public HealthMonitorV2Concretebuilder() {
            this(new NeutronHealthMonitorV2());
        }

        public HealthMonitorV2Concretebuilder(NeutronHealthMonitorV2 m) {
            this.m = m;
        }

        @Override
        public HealthMonitorV2 build() {
            return this.m;
        }

        @Override
        public HealthMonitorV2Builder from(HealthMonitorV2 in) {
            this.m = (NeutronHealthMonitorV2)in;
            return this;
        }

        @Override
        public HealthMonitorV2Builder tenantId(String tenantId) {
            this.m.tenantId = tenantId;
            return this;
        }

        @Override
        public HealthMonitorV2Builder type(HealthMonitorType type) {
            this.m.type = type;
            return this;
        }

        @Override
        public HealthMonitorV2Builder delay(Integer delay) {
            this.m.delay = delay;
            return this;
        }

        @Override
        public HealthMonitorV2Builder timeout(Integer timeout) {
            this.m.timeout = timeout;
            return this;
        }

        @Override
        public HealthMonitorV2Builder maxRetries(Integer maxRetries) {
            this.m.maxRetries = maxRetries;
            return this;
        }

        @Override
        public HealthMonitorV2Builder urlPath(String urlPath) {
            this.m.urlPath = urlPath;
            return this;
        }

        @Override
        public HealthMonitorV2Builder expectedCodes(String expectedCodes) {
            this.m.expectedCodes = expectedCodes;
            return this;
        }

        @Override
        public HealthMonitorV2Builder httpMethod(String httpMethod) {
            this.m.httpMethod = httpMethod;
            return this;
        }

        @Override
        public HealthMonitorV2Builder adminStateUp(boolean adminStateUp) {
            this.m.adminStateUp = adminStateUp;
            return this;
        }

        @Override
        public HealthMonitorV2Builder poolId(String poolId) {
            this.m.poolId = poolId;
            return this;
        }
    }

    public static class HealthMonitorsV2
    extends ListResult<NeutronHealthMonitorV2> {
        @JsonProperty(value="healthmonitors")
        List<NeutronHealthMonitorV2> healthMonitors;

        @Override
        public List<NeutronHealthMonitorV2> value() {
            return this.healthMonitors;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).omitNullValues().add("healthMonitors", this.healthMonitors).toString();
        }
    }
}

