/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain.ext;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import org.openstack4j.model.network.ext.MemberUpdate;
import org.openstack4j.model.network.ext.builder.MemberUpdateBuilder;

@JsonRootName(value="member")
@JsonIgnoreProperties(ignoreUnknown=true)
public class NeutronMemberUpdate
implements MemberUpdate {
    private static final long serialVersionUID = 1L;
    private Integer weight;
    @JsonProperty(value="admin_state_up")
    private boolean adminStateUp;
    @JsonProperty(value="pool_id")
    private String poolId;

    public static MemberUpdateBuilder builder() {
        return new MemberUpdateConcreteBuilder();
    }

    @Override
    public boolean isAdminStateUp() {
        return this.adminStateUp;
    }

    @Override
    public Integer getWeight() {
        return this.weight;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("adminStateUp", this.adminStateUp).add("weight", this.weight).add("poolId", this.poolId).toString();
    }

    @Override
    public MemberUpdateBuilder toBuilder() {
        return new MemberUpdateConcreteBuilder(this);
    }

    @Override
    public String getPoolId() {
        return this.poolId;
    }

    public static class MemberUpdateConcreteBuilder
    implements MemberUpdateBuilder {
        private NeutronMemberUpdate m;

        public MemberUpdateConcreteBuilder() {
            this(new NeutronMemberUpdate());
        }

        public MemberUpdateConcreteBuilder(NeutronMemberUpdate m) {
            this.m = m;
        }

        @Override
        public MemberUpdateBuilder from(MemberUpdate in) {
            this.m = (NeutronMemberUpdate)in;
            return this;
        }

        @Override
        public MemberUpdate build() {
            return this.m;
        }

        @Override
        public MemberUpdateBuilder adminStateUp(boolean adminStateUp) {
            this.m.adminStateUp = adminStateUp;
            return this;
        }

        @Override
        public MemberUpdateBuilder weight(Integer weight) {
            this.m.weight = weight;
            return this;
        }

        @Override
        public MemberUpdateBuilder poolId(String poolId) {
            this.m.poolId = poolId;
            return this;
        }
    }
}

