/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain.ext;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import java.util.List;
import org.openstack4j.model.network.ext.MemberV2;
import org.openstack4j.model.network.ext.builder.MemberV2Builder;
import org.openstack4j.openstack.common.ListResult;

@JsonRootName(value="member")
@JsonIgnoreProperties(ignoreUnknown=true)
public class NeutronMemberV2
implements MemberV2 {
    private String id;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    private String address;
    @JsonProperty(value="protocol_port")
    private Integer protocolPort;
    private Integer weight;
    @JsonProperty(value="subnet_id")
    private String subnetId;
    @JsonProperty(value="admin_state_up")
    private boolean adminStateUp = true;

    public static MemberV2Builder builder() {
        return new MemberV2ConcreteBuilder();
    }

    @Override
    public boolean isAdminStateUp() {
        return this.adminStateUp;
    }

    @Override
    public String getSubnetId() {
        return this.subnetId;
    }

    @Override
    public Integer getWeight() {
        return this.weight;
    }

    @Override
    public Integer getProtocolPort() {
        return this.protocolPort;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("tenantId", this.tenantId).add("address", this.address).add("protocolPort", this.protocolPort).add("adminStateUp", this.adminStateUp).add("weight", this.weight).add("subnetId", this.subnetId).toString();
    }

    @Override
    public MemberV2Builder toBuilder() {
        return new MemberV2ConcreteBuilder(this);
    }

    public static class MemberV2ConcreteBuilder
    implements MemberV2Builder {
        private NeutronMemberV2 m;

        public MemberV2ConcreteBuilder() {
            this(new NeutronMemberV2());
        }

        public MemberV2ConcreteBuilder(NeutronMemberV2 m) {
            this.m = m;
        }

        @Override
        public MemberV2 build() {
            return this.m;
        }

        @Override
        public MemberV2Builder from(MemberV2 in) {
            this.m = (NeutronMemberV2)in;
            return this;
        }

        @Override
        public MemberV2Builder tenantId(String tenantId) {
            this.m.tenantId = tenantId;
            return this;
        }

        @Override
        public MemberV2Builder address(String address) {
            this.m.address = address;
            return this;
        }

        @Override
        public MemberV2Builder protocolPort(Integer protocolPort) {
            this.m.protocolPort = protocolPort;
            return this;
        }

        @Override
        public MemberV2Builder subnetId(String subnetId) {
            this.m.subnetId = subnetId;
            return this;
        }

        @Override
        public MemberV2Builder weight(Integer weight) {
            this.m.weight = weight;
            return this;
        }

        @Override
        public MemberV2Builder adminStateUp(boolean adminStateUp) {
            this.m.adminStateUp = adminStateUp;
            return this;
        }
    }

    public static class MembersV2
    extends ListResult<NeutronMemberV2> {
        @JsonProperty(value="members")
        List<NeutronMemberV2> members;

        @Override
        protected List<NeutronMemberV2> value() {
            return this.members;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("members", this.members).toString();
        }
    }
}

