/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.domain.ext;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import org.openstack4j.model.network.ext.SessionPersistence;
import org.openstack4j.model.network.ext.SessionPersistenceType;
import org.openstack4j.model.network.ext.builder.SessionPersistenceBuilder;

@JsonRootName(value="session_persistence")
@JsonIgnoreProperties(ignoreUnknown=true)
public class NeutronSessionPersistence
implements SessionPersistence {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="cookie_name")
    private String cookieName;
    private SessionPersistenceType type;

    public static SessionPersistenceBuilder builder() {
        return new SessionPersistenceContreteBuilder();
    }

    @Override
    public SessionPersistenceBuilder toBuilder() {
        return new SessionPersistenceContreteBuilder();
    }

    @Override
    public String getCookieName() {
        return this.cookieName;
    }

    @Override
    public SessionPersistenceType getType() {
        return this.type;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("type", (Object)this.type).add("cookieName", this.cookieName).toString();
    }

    public static class SessionPersistenceContreteBuilder
    implements SessionPersistenceBuilder {
        private NeutronSessionPersistence m;

        public SessionPersistenceContreteBuilder() {
            this(new NeutronSessionPersistence());
        }

        public SessionPersistenceContreteBuilder(NeutronSessionPersistence m) {
            this.m = m;
        }

        @Override
        public SessionPersistenceBuilder from(SessionPersistence in) {
            this.m = (NeutronSessionPersistence)in;
            return this;
        }

        @Override
        public SessionPersistenceBuilder type(SessionPersistenceType type) {
            this.m.type = type;
            return this;
        }

        @Override
        public SessionPersistenceBuilder cookieName(String cookieName) {
            this.m.cookieName = cookieName;
            return this;
        }

        @Override
        public SessionPersistence build() {
            return this.m;
        }
    }
}

