/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.internal;

import com.google.common.base.Preconditions;
import org.openstack4j.api.networking.NeutronResourceTagService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.Resource;
import org.openstack4j.openstack.networking.domain.NeutronResourceTag;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class NeutronResourceTagServiceImpl
extends BaseNetworkingServices
implements NeutronResourceTagService {
    @Override
    public ActionResponse check(Resource resource, String resourceId, String tag) {
        Preconditions.checkNotNull(resourceId);
        Preconditions.checkNotNull(tag);
        Preconditions.checkNotNull(resource);
        String resourceType = Preconditions.checkNotNull(Resource.forValue(resource));
        return this.getWithResponse(this.uri("/%s/%s/tags/%s", resourceType, resourceId, tag)).execute();
    }

    @Override
    public NeutronResourceTag list(Resource resource, String securityGroupId) {
        Preconditions.checkNotNull(securityGroupId);
        Preconditions.checkNotNull(resource);
        String resourceType = Preconditions.checkNotNull(Resource.forValue(resource));
        return this.get(NeutronResourceTag.class, this.uri("/%s/%s/tags", resourceType, securityGroupId)).execute();
    }

    @Override
    public ActionResponse addSingle(Resource resource, String securityGroupId, String tag) {
        Preconditions.checkNotNull(securityGroupId);
        Preconditions.checkNotNull(tag);
        Preconditions.checkNotNull(resource);
        String resourceType = Preconditions.checkNotNull(Resource.forValue(resource));
        return this.putWithResponse(this.uri("/%s/%s/tags/%s", resourceType, securityGroupId, tag)).execute();
    }

    @Override
    public NeutronResourceTag replace(Resource resource, String securityGroupId, NeutronResourceTag tags) {
        Preconditions.checkNotNull(securityGroupId);
        Preconditions.checkNotNull(tags);
        Preconditions.checkNotNull(resource);
        String resourceType = Preconditions.checkNotNull(Resource.forValue(resource));
        return this.put(NeutronResourceTag.class, this.uri("/%s/%s/tags", resourceType, securityGroupId)).entity(tags).execute();
    }

    @Override
    public ActionResponse delete(Resource resource, String securityGroupId, String tag) {
        Preconditions.checkNotNull(securityGroupId);
        Preconditions.checkNotNull(tag);
        Preconditions.checkNotNull(resource);
        String resourceType = Preconditions.checkNotNull(Resource.forValue(resource));
        return this.deleteWithResponse(this.uri("/%s/%s/tags/%s", resourceType, securityGroupId, tag)).execute();
    }

    @Override
    public ActionResponse deleteAll(Resource resource, String securityGroupId) {
        Preconditions.checkNotNull(securityGroupId);
        Preconditions.checkNotNull(resource);
        String resourceType = Preconditions.checkNotNull(Resource.forValue(resource));
        return this.deleteWithResponse(this.uri("/%s/%s/tags", resourceType, securityGroupId)).execute();
    }
}

