/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.openstack4j.api.networking.SecurityGroupService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.network.SecurityGroup;
import org.openstack4j.model.network.SecurityGroupUpdate;
import org.openstack4j.openstack.internal.BaseOpenStackService;
import org.openstack4j.openstack.networking.domain.NeutronSecurityGroup;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class SecurityGroupServiceImpl
extends BaseNetworkingServices
implements SecurityGroupService {
    @Override
    public SecurityGroup get(String id) {
        Preconditions.checkNotNull(id);
        return this.get(NeutronSecurityGroup.class, this.uri("/security-groups/%s", id)).execute();
    }

    @Override
    public ActionResponse delete(String groupId) {
        Preconditions.checkNotNull(groupId);
        return this.deleteWithResponse(this.uri("/security-groups/%s", groupId)).execute();
    }

    @Override
    public SecurityGroup create(SecurityGroup securityGroup) {
        Preconditions.checkNotNull(securityGroup);
        return this.post(NeutronSecurityGroup.class, this.uri("/security-groups", new Object[0])).entity(securityGroup).execute();
    }

    @Override
    public SecurityGroup update(String securityGroupId, SecurityGroupUpdate securityGroupUpdate) {
        Preconditions.checkNotNull(securityGroupId);
        Preconditions.checkNotNull(securityGroupUpdate);
        return this.put(NeutronSecurityGroup.class, this.uri("/security-groups/%s", securityGroupId)).entity(securityGroupUpdate).execute();
    }

    @Override
    public List<? extends SecurityGroup> list() {
        return this.get(NeutronSecurityGroup.SecurityGroups.class, this.uri("/security-groups", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends SecurityGroup> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NeutronSecurityGroup.SecurityGroups> securityGroupInvocation = this.get(NeutronSecurityGroup.SecurityGroups.class, "/security-groups");
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                securityGroupInvocation = securityGroupInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return securityGroupInvocation.execute().getList();
    }
}

